package zio.aws.elasticsearch.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ColdStorageOptions(enabled: Boolean) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.ColdStorageOptions = {
    import ColdStorageOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.ColdStorageOptions
      .builder()
      .enabled(enabled: java.lang.Boolean)
      .build()
  }
  def asReadOnly: zio.aws.elasticsearch.model.ColdStorageOptions.ReadOnly =
    zio.aws.elasticsearch.model.ColdStorageOptions.wrap(buildAwsValue())
}
object ColdStorageOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.ColdStorageOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.ColdStorageOptions =
      zio.aws.elasticsearch.model.ColdStorageOptions(enabled)
    def enabled: Boolean
    def getEnabled: ZIO[Any, Nothing, Boolean] = ZIO.succeed(enabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.ColdStorageOptions
  ) extends zio.aws.elasticsearch.model.ColdStorageOptions.ReadOnly {
    override val enabled: Boolean = impl.enabled(): Boolean
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.ColdStorageOptions
  ): zio.aws.elasticsearch.model.ColdStorageOptions.ReadOnly = new Wrapper(impl)
}
