package zio.aws.elasticsearch.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.elasticsearch.model.primitives.{
  NextToken,
  MaxResults,
  DomainName
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListPackagesForDomainRequest(
    domainName: DomainName,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.ListPackagesForDomainRequest = {
    import ListPackagesForDomainRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.ListPackagesForDomainRequest
      .builder()
      .domainName(DomainName.unwrap(domainName): java.lang.String)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.ListPackagesForDomainRequest.ReadOnly =
    zio.aws.elasticsearch.model.ListPackagesForDomainRequest
      .wrap(buildAwsValue())
}
object ListPackagesForDomainRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.ListPackagesForDomainRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.ListPackagesForDomainRequest =
      zio.aws.elasticsearch.model.ListPackagesForDomainRequest(
        domainName,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def domainName: DomainName
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def getDomainName: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domainName)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.ListPackagesForDomainRequest
  ) extends zio.aws.elasticsearch.model.ListPackagesForDomainRequest.ReadOnly {
    override val domainName: DomainName =
      zio.aws.elasticsearch.model.primitives.DomainName(impl.domainName())
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.elasticsearch.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.elasticsearch.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.ListPackagesForDomainRequest
  ): zio.aws.elasticsearch.model.ListPackagesForDomainRequest.ReadOnly =
    new Wrapper(impl)
}
