package zio.aws.elasticsearch.model
import zio.aws.elasticsearch.model.primitives.DisableTimestamp
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class AdvancedSecurityOptions(
    enabled: Option[Boolean] = None,
    internalUserDatabaseEnabled: Option[Boolean] = None,
    samlOptions: Option[zio.aws.elasticsearch.model.SAMLOptionsOutput] = None,
    anonymousAuthDisableDate: Option[DisableTimestamp] = None,
    anonymousAuthEnabled: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.AdvancedSecurityOptions = {
    import AdvancedSecurityOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.AdvancedSecurityOptions
      .builder()
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .optionallyWith(
        internalUserDatabaseEnabled.map(value => value: java.lang.Boolean)
      )(_.internalUserDatabaseEnabled)
      .optionallyWith(samlOptions.map(value => value.buildAwsValue()))(
        _.samlOptions
      )
      .optionallyWith(
        anonymousAuthDisableDate.map(value =>
          DisableTimestamp.unwrap(value): Instant
        )
      )(_.anonymousAuthDisableDate)
      .optionallyWith(
        anonymousAuthEnabled.map(value => value: java.lang.Boolean)
      )(_.anonymousAuthEnabled)
      .build()
  }
  def asReadOnly: zio.aws.elasticsearch.model.AdvancedSecurityOptions.ReadOnly =
    zio.aws.elasticsearch.model.AdvancedSecurityOptions.wrap(buildAwsValue())
}
object AdvancedSecurityOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.AdvancedSecurityOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.AdvancedSecurityOptions =
      zio.aws.elasticsearch.model.AdvancedSecurityOptions(
        enabled.map(value => value),
        internalUserDatabaseEnabled.map(value => value),
        samlOptions.map(value => value.asEditable),
        anonymousAuthDisableDate.map(value => value),
        anonymousAuthEnabled.map(value => value)
      )
    def enabled: Option[Boolean]
    def internalUserDatabaseEnabled: Option[Boolean]
    def samlOptions
        : Option[zio.aws.elasticsearch.model.SAMLOptionsOutput.ReadOnly]
    def anonymousAuthDisableDate: Option[DisableTimestamp]
    def anonymousAuthEnabled: Option[Boolean]
    def getEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getInternalUserDatabaseEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "internalUserDatabaseEnabled",
        internalUserDatabaseEnabled
      )
    def getSamlOptions: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.SAMLOptionsOutput.ReadOnly
    ] = AwsError.unwrapOptionField("samlOptions", samlOptions)
    def getAnonymousAuthDisableDate: ZIO[Any, AwsError, DisableTimestamp] =
      AwsError.unwrapOptionField(
        "anonymousAuthDisableDate",
        anonymousAuthDisableDate
      )
    def getAnonymousAuthEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("anonymousAuthEnabled", anonymousAuthEnabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.AdvancedSecurityOptions
  ) extends zio.aws.elasticsearch.model.AdvancedSecurityOptions.ReadOnly {
    override val enabled: Option[Boolean] =
      scala.Option(impl.enabled()).map(value => value: Boolean)
    override val internalUserDatabaseEnabled: Option[Boolean] = scala
      .Option(impl.internalUserDatabaseEnabled())
      .map(value => value: Boolean)
    override val samlOptions
        : Option[zio.aws.elasticsearch.model.SAMLOptionsOutput.ReadOnly] = scala
      .Option(impl.samlOptions())
      .map(value => zio.aws.elasticsearch.model.SAMLOptionsOutput.wrap(value))
    override val anonymousAuthDisableDate: Option[DisableTimestamp] = scala
      .Option(impl.anonymousAuthDisableDate())
      .map(value =>
        zio.aws.elasticsearch.model.primitives.DisableTimestamp(value)
      )
    override val anonymousAuthEnabled: Option[Boolean] =
      scala.Option(impl.anonymousAuthEnabled()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.AdvancedSecurityOptions
  ): zio.aws.elasticsearch.model.AdvancedSecurityOptions.ReadOnly = new Wrapper(
    impl
  )
}
