package zio.aws.elasticsearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListDomainNamesResponse(
    domainNames: Option[Iterable[zio.aws.elasticsearch.model.DomainInfo]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.ListDomainNamesResponse = {
    import ListDomainNamesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.ListDomainNamesResponse
      .builder()
      .optionallyWith(
        domainNames.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.domainNames)
      .build()
  }
  def asReadOnly: zio.aws.elasticsearch.model.ListDomainNamesResponse.ReadOnly =
    zio.aws.elasticsearch.model.ListDomainNamesResponse.wrap(buildAwsValue())
}
object ListDomainNamesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.ListDomainNamesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.ListDomainNamesResponse =
      zio.aws.elasticsearch.model.ListDomainNamesResponse(
        domainNames.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def domainNames
        : Option[List[zio.aws.elasticsearch.model.DomainInfo.ReadOnly]]
    def getDomainNames: ZIO[Any, AwsError, List[
      zio.aws.elasticsearch.model.DomainInfo.ReadOnly
    ]] = AwsError.unwrapOptionField("domainNames", domainNames)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.ListDomainNamesResponse
  ) extends zio.aws.elasticsearch.model.ListDomainNamesResponse.ReadOnly {
    override val domainNames
        : Option[List[zio.aws.elasticsearch.model.DomainInfo.ReadOnly]] = scala
      .Option(impl.domainNames())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticsearch.model.DomainInfo.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.ListDomainNamesResponse
  ): zio.aws.elasticsearch.model.ListDomainNamesResponse.ReadOnly = new Wrapper(
    impl
  )
}
