package zio.aws.elasticsearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AutoTuneDetails(
    scheduledAutoTuneDetails: Option[
      zio.aws.elasticsearch.model.ScheduledAutoTuneDetails
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.AutoTuneDetails = {
    import AutoTuneDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.AutoTuneDetails
      .builder()
      .optionallyWith(
        scheduledAutoTuneDetails.map(value => value.buildAwsValue())
      )(_.scheduledAutoTuneDetails)
      .build()
  }
  def asReadOnly: zio.aws.elasticsearch.model.AutoTuneDetails.ReadOnly =
    zio.aws.elasticsearch.model.AutoTuneDetails.wrap(buildAwsValue())
}
object AutoTuneDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.AutoTuneDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.AutoTuneDetails =
      zio.aws.elasticsearch.model.AutoTuneDetails(
        scheduledAutoTuneDetails.map(value => value.asEditable)
      )
    def scheduledAutoTuneDetails
        : Option[zio.aws.elasticsearch.model.ScheduledAutoTuneDetails.ReadOnly]
    def getScheduledAutoTuneDetails: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.ScheduledAutoTuneDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "scheduledAutoTuneDetails",
      scheduledAutoTuneDetails
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.AutoTuneDetails
  ) extends zio.aws.elasticsearch.model.AutoTuneDetails.ReadOnly {
    override val scheduledAutoTuneDetails: Option[
      zio.aws.elasticsearch.model.ScheduledAutoTuneDetails.ReadOnly
    ] = scala
      .Option(impl.scheduledAutoTuneDetails())
      .map(value =>
        zio.aws.elasticsearch.model.ScheduledAutoTuneDetails.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.AutoTuneDetails
  ): zio.aws.elasticsearch.model.AutoTuneDetails.ReadOnly = new Wrapper(impl)
}
