package zio.aws.elasticsearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class VPCDerivedInfo(
    vpcId: Option[String] = None,
    subnetIds: Option[Iterable[String]] = None,
    availabilityZones: Option[Iterable[String]] = None,
    securityGroupIds: Option[Iterable[String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.VPCDerivedInfo = {
    import VPCDerivedInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.VPCDerivedInfo
      .builder()
      .optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId)
      .optionallyWith(
        subnetIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.subnetIds)
      .optionallyWith(
        availabilityZones.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.availabilityZones)
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .build()
  }
  def asReadOnly: zio.aws.elasticsearch.model.VPCDerivedInfo.ReadOnly =
    zio.aws.elasticsearch.model.VPCDerivedInfo.wrap(buildAwsValue())
}
object VPCDerivedInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.VPCDerivedInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.VPCDerivedInfo =
      zio.aws.elasticsearch.model.VPCDerivedInfo(
        vpcId.map(value => value),
        subnetIds.map(value => value),
        availabilityZones.map(value => value),
        securityGroupIds.map(value => value)
      )
    def vpcId: Option[String]
    def subnetIds: Option[List[String]]
    def availabilityZones: Option[List[String]]
    def securityGroupIds: Option[List[String]]
    def getVpcId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getSubnetIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("subnetIds", subnetIds)
    def getAvailabilityZones: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("availabilityZones", availabilityZones)
    def getSecurityGroupIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.VPCDerivedInfo
  ) extends zio.aws.elasticsearch.model.VPCDerivedInfo.ReadOnly {
    override val vpcId: Option[String] =
      scala.Option(impl.vpcId()).map(value => value: String)
    override val subnetIds: Option[List[String]] = scala
      .Option(impl.subnetIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val availabilityZones: Option[List[String]] = scala
      .Option(impl.availabilityZones())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val securityGroupIds: Option[List[String]] = scala
      .Option(impl.securityGroupIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.VPCDerivedInfo
  ): zio.aws.elasticsearch.model.VPCDerivedInfo.ReadOnly = new Wrapper(impl)
}
