package zio.aws.elasticsearch.model
import zio.aws.elasticsearch.model.primitives.{
  RoleArn,
  IdentityPoolId,
  UserPoolId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CognitoOptions(
    enabled: Option[Boolean] = None,
    userPoolId: Option[UserPoolId] = None,
    identityPoolId: Option[IdentityPoolId] = None,
    roleArn: Option[RoleArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.CognitoOptions = {
    import CognitoOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.CognitoOptions
      .builder()
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .optionallyWith(
        userPoolId.map(value => UserPoolId.unwrap(value): java.lang.String)
      )(_.userPoolId)
      .optionallyWith(
        identityPoolId.map(value =>
          IdentityPoolId.unwrap(value): java.lang.String
        )
      )(_.identityPoolId)
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .build()
  }
  def asReadOnly: zio.aws.elasticsearch.model.CognitoOptions.ReadOnly =
    zio.aws.elasticsearch.model.CognitoOptions.wrap(buildAwsValue())
}
object CognitoOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.CognitoOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.CognitoOptions =
      zio.aws.elasticsearch.model.CognitoOptions(
        enabled.map(value => value),
        userPoolId.map(value => value),
        identityPoolId.map(value => value),
        roleArn.map(value => value)
      )
    def enabled: Option[Boolean]
    def userPoolId: Option[UserPoolId]
    def identityPoolId: Option[IdentityPoolId]
    def roleArn: Option[RoleArn]
    def getEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getUserPoolId: ZIO[Any, AwsError, UserPoolId] =
      AwsError.unwrapOptionField("userPoolId", userPoolId)
    def getIdentityPoolId: ZIO[Any, AwsError, IdentityPoolId] =
      AwsError.unwrapOptionField("identityPoolId", identityPoolId)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.CognitoOptions
  ) extends zio.aws.elasticsearch.model.CognitoOptions.ReadOnly {
    override val enabled: Option[Boolean] =
      scala.Option(impl.enabled()).map(value => value: Boolean)
    override val userPoolId: Option[UserPoolId] = scala
      .Option(impl.userPoolId())
      .map(value => zio.aws.elasticsearch.model.primitives.UserPoolId(value))
    override val identityPoolId: Option[IdentityPoolId] = scala
      .Option(impl.identityPoolId())
      .map(value =>
        zio.aws.elasticsearch.model.primitives.IdentityPoolId(value)
      )
    override val roleArn: Option[RoleArn] = scala
      .Option(impl.roleArn())
      .map(value => zio.aws.elasticsearch.model.primitives.RoleArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.CognitoOptions
  ): zio.aws.elasticsearch.model.CognitoOptions.ReadOnly = new Wrapper(impl)
}
