package zio.aws.elasticsearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetCompatibleElasticsearchVersionsResponse(
    compatibleElasticsearchVersions: Option[
      Iterable[zio.aws.elasticsearch.model.CompatibleVersionsMap]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.GetCompatibleElasticsearchVersionsResponse = {
    import GetCompatibleElasticsearchVersionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.GetCompatibleElasticsearchVersionsResponse
      .builder()
      .optionallyWith(
        compatibleElasticsearchVersions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.compatibleElasticsearchVersions)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.GetCompatibleElasticsearchVersionsResponse.ReadOnly =
    zio.aws.elasticsearch.model.GetCompatibleElasticsearchVersionsResponse
      .wrap(buildAwsValue())
}
object GetCompatibleElasticsearchVersionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.GetCompatibleElasticsearchVersionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticsearch.model.GetCompatibleElasticsearchVersionsResponse =
      zio.aws.elasticsearch.model.GetCompatibleElasticsearchVersionsResponse(
        compatibleElasticsearchVersions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def compatibleElasticsearchVersions: Option[
      List[zio.aws.elasticsearch.model.CompatibleVersionsMap.ReadOnly]
    ]
    def getCompatibleElasticsearchVersions: ZIO[Any, AwsError, List[
      zio.aws.elasticsearch.model.CompatibleVersionsMap.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "compatibleElasticsearchVersions",
      compatibleElasticsearchVersions
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.GetCompatibleElasticsearchVersionsResponse
  ) extends zio.aws.elasticsearch.model.GetCompatibleElasticsearchVersionsResponse.ReadOnly {
    override val compatibleElasticsearchVersions: Option[
      List[zio.aws.elasticsearch.model.CompatibleVersionsMap.ReadOnly]
    ] = scala
      .Option(impl.compatibleElasticsearchVersions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticsearch.model.CompatibleVersionsMap.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.GetCompatibleElasticsearchVersionsResponse
  ): zio.aws.elasticsearch.model.GetCompatibleElasticsearchVersionsResponse.ReadOnly =
    new Wrapper(impl)
}
