package zio.aws.elasticsearch.model
import java.lang.Integer
import zio.aws.elasticsearch.model.primitives.{
  NextToken,
  MaxResults,
  DomainName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeDomainAutoTunesRequest(
    domainName: DomainName,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.DescribeDomainAutoTunesRequest = {
    import DescribeDomainAutoTunesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.DescribeDomainAutoTunesRequest
      .builder()
      .domainName(DomainName.unwrap(domainName): java.lang.String)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.DescribeDomainAutoTunesRequest.ReadOnly =
    zio.aws.elasticsearch.model.DescribeDomainAutoTunesRequest
      .wrap(buildAwsValue())
}
object DescribeDomainAutoTunesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.DescribeDomainAutoTunesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.DescribeDomainAutoTunesRequest =
      zio.aws.elasticsearch.model.DescribeDomainAutoTunesRequest(
        domainName,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def domainName: DomainName
    def maxResults: Option[MaxResults]
    def nextToken: Option[NextToken]
    def getDomainName: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domainName)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.DescribeDomainAutoTunesRequest
  ) extends zio.aws.elasticsearch.model.DescribeDomainAutoTunesRequest.ReadOnly {
    override val domainName: DomainName =
      zio.aws.elasticsearch.model.primitives.DomainName(impl.domainName())
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.elasticsearch.model.primitives.MaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.elasticsearch.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.DescribeDomainAutoTunesRequest
  ): zio.aws.elasticsearch.model.DescribeDomainAutoTunesRequest.ReadOnly =
    new Wrapper(impl)
}
