package zio.aws.elasticsearch.model
import zio.aws.elasticsearch.model.primitives.{
  PolicyDocument,
  ElasticsearchVersionString,
  DomainName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateElasticsearchDomainRequest(
    domainName: DomainName,
    elasticsearchVersion: Option[ElasticsearchVersionString] = None,
    elasticsearchClusterConfig: Option[
      zio.aws.elasticsearch.model.ElasticsearchClusterConfig
    ] = None,
    ebsOptions: Option[zio.aws.elasticsearch.model.EBSOptions] = None,
    accessPolicies: Option[PolicyDocument] = None,
    snapshotOptions: Option[zio.aws.elasticsearch.model.SnapshotOptions] = None,
    vpcOptions: Option[zio.aws.elasticsearch.model.VPCOptions] = None,
    cognitoOptions: Option[zio.aws.elasticsearch.model.CognitoOptions] = None,
    encryptionAtRestOptions: Option[
      zio.aws.elasticsearch.model.EncryptionAtRestOptions
    ] = None,
    nodeToNodeEncryptionOptions: Option[
      zio.aws.elasticsearch.model.NodeToNodeEncryptionOptions
    ] = None,
    advancedOptions: Option[Map[String, String]] = None,
    logPublishingOptions: Option[Map[
      zio.aws.elasticsearch.model.LogType,
      zio.aws.elasticsearch.model.LogPublishingOption
    ]] = None,
    domainEndpointOptions: Option[
      zio.aws.elasticsearch.model.DomainEndpointOptions
    ] = None,
    advancedSecurityOptions: Option[
      zio.aws.elasticsearch.model.AdvancedSecurityOptionsInput
    ] = None,
    autoTuneOptions: Option[zio.aws.elasticsearch.model.AutoTuneOptionsInput] =
      None,
    tagList: Option[Iterable[zio.aws.elasticsearch.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.CreateElasticsearchDomainRequest = {
    import CreateElasticsearchDomainRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.CreateElasticsearchDomainRequest
      .builder()
      .domainName(DomainName.unwrap(domainName): java.lang.String)
      .optionallyWith(
        elasticsearchVersion.map(value =>
          ElasticsearchVersionString.unwrap(value): java.lang.String
        )
      )(_.elasticsearchVersion)
      .optionallyWith(
        elasticsearchClusterConfig.map(value => value.buildAwsValue())
      )(_.elasticsearchClusterConfig)
      .optionallyWith(ebsOptions.map(value => value.buildAwsValue()))(
        _.ebsOptions
      )
      .optionallyWith(
        accessPolicies.map(value =>
          PolicyDocument.unwrap(value): java.lang.String
        )
      )(_.accessPolicies)
      .optionallyWith(snapshotOptions.map(value => value.buildAwsValue()))(
        _.snapshotOptions
      )
      .optionallyWith(vpcOptions.map(value => value.buildAwsValue()))(
        _.vpcOptions
      )
      .optionallyWith(cognitoOptions.map(value => value.buildAwsValue()))(
        _.cognitoOptions
      )
      .optionallyWith(
        encryptionAtRestOptions.map(value => value.buildAwsValue())
      )(_.encryptionAtRestOptions)
      .optionallyWith(
        nodeToNodeEncryptionOptions.map(value => value.buildAwsValue())
      )(_.nodeToNodeEncryptionOptions)
      .optionallyWith(
        advancedOptions.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.advancedOptions)
      .optionallyWith(
        logPublishingOptions.map(value =>
          value
            .map({ case (key, value) =>
              key.unwrap.toString -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.logPublishingOptionsWithStrings)
      .optionallyWith(
        domainEndpointOptions.map(value => value.buildAwsValue())
      )(_.domainEndpointOptions)
      .optionallyWith(
        advancedSecurityOptions.map(value => value.buildAwsValue())
      )(_.advancedSecurityOptions)
      .optionallyWith(autoTuneOptions.map(value => value.buildAwsValue()))(
        _.autoTuneOptions
      )
      .optionallyWith(
        tagList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagList)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.CreateElasticsearchDomainRequest.ReadOnly =
    zio.aws.elasticsearch.model.CreateElasticsearchDomainRequest
      .wrap(buildAwsValue())
}
object CreateElasticsearchDomainRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.CreateElasticsearchDomainRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticsearch.model.CreateElasticsearchDomainRequest =
      zio.aws.elasticsearch.model.CreateElasticsearchDomainRequest(
        domainName,
        elasticsearchVersion.map(value => value),
        elasticsearchClusterConfig.map(value => value.asEditable),
        ebsOptions.map(value => value.asEditable),
        accessPolicies.map(value => value),
        snapshotOptions.map(value => value.asEditable),
        vpcOptions.map(value => value.asEditable),
        cognitoOptions.map(value => value.asEditable),
        encryptionAtRestOptions.map(value => value.asEditable),
        nodeToNodeEncryptionOptions.map(value => value.asEditable),
        advancedOptions.map(value => value),
        logPublishingOptions.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        domainEndpointOptions.map(value => value.asEditable),
        advancedSecurityOptions.map(value => value.asEditable),
        autoTuneOptions.map(value => value.asEditable),
        tagList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def domainName: DomainName
    def elasticsearchVersion: Option[ElasticsearchVersionString]
    def elasticsearchClusterConfig: Option[
      zio.aws.elasticsearch.model.ElasticsearchClusterConfig.ReadOnly
    ]
    def ebsOptions: Option[zio.aws.elasticsearch.model.EBSOptions.ReadOnly]
    def accessPolicies: Option[PolicyDocument]
    def snapshotOptions
        : Option[zio.aws.elasticsearch.model.SnapshotOptions.ReadOnly]
    def vpcOptions: Option[zio.aws.elasticsearch.model.VPCOptions.ReadOnly]
    def cognitoOptions
        : Option[zio.aws.elasticsearch.model.CognitoOptions.ReadOnly]
    def encryptionAtRestOptions
        : Option[zio.aws.elasticsearch.model.EncryptionAtRestOptions.ReadOnly]
    def nodeToNodeEncryptionOptions: Option[
      zio.aws.elasticsearch.model.NodeToNodeEncryptionOptions.ReadOnly
    ]
    def advancedOptions: Option[Map[String, String]]
    def logPublishingOptions: Option[Map[
      zio.aws.elasticsearch.model.LogType,
      zio.aws.elasticsearch.model.LogPublishingOption.ReadOnly
    ]]
    def domainEndpointOptions
        : Option[zio.aws.elasticsearch.model.DomainEndpointOptions.ReadOnly]
    def advancedSecurityOptions: Option[
      zio.aws.elasticsearch.model.AdvancedSecurityOptionsInput.ReadOnly
    ]
    def autoTuneOptions
        : Option[zio.aws.elasticsearch.model.AutoTuneOptionsInput.ReadOnly]
    def tagList: Option[List[zio.aws.elasticsearch.model.Tag.ReadOnly]]
    def getDomainName: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domainName)
    def getElasticsearchVersion
        : ZIO[Any, AwsError, ElasticsearchVersionString] =
      AwsError.unwrapOptionField("elasticsearchVersion", elasticsearchVersion)
    def getElasticsearchClusterConfig: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.ElasticsearchClusterConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "elasticsearchClusterConfig",
      elasticsearchClusterConfig
    )
    def getEbsOptions
        : ZIO[Any, AwsError, zio.aws.elasticsearch.model.EBSOptions.ReadOnly] =
      AwsError.unwrapOptionField("ebsOptions", ebsOptions)
    def getAccessPolicies: ZIO[Any, AwsError, PolicyDocument] =
      AwsError.unwrapOptionField("accessPolicies", accessPolicies)
    def getSnapshotOptions: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.SnapshotOptions.ReadOnly
    ] = AwsError.unwrapOptionField("snapshotOptions", snapshotOptions)
    def getVpcOptions
        : ZIO[Any, AwsError, zio.aws.elasticsearch.model.VPCOptions.ReadOnly] =
      AwsError.unwrapOptionField("vpcOptions", vpcOptions)
    def getCognitoOptions: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.CognitoOptions.ReadOnly
    ] = AwsError.unwrapOptionField("cognitoOptions", cognitoOptions)
    def getEncryptionAtRestOptions: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.EncryptionAtRestOptions.ReadOnly
    ] = AwsError.unwrapOptionField(
      "encryptionAtRestOptions",
      encryptionAtRestOptions
    )
    def getNodeToNodeEncryptionOptions: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.NodeToNodeEncryptionOptions.ReadOnly
    ] = AwsError.unwrapOptionField(
      "nodeToNodeEncryptionOptions",
      nodeToNodeEncryptionOptions
    )
    def getAdvancedOptions: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("advancedOptions", advancedOptions)
    def getLogPublishingOptions: ZIO[Any, AwsError, Map[
      zio.aws.elasticsearch.model.LogType,
      zio.aws.elasticsearch.model.LogPublishingOption.ReadOnly
    ]] =
      AwsError.unwrapOptionField("logPublishingOptions", logPublishingOptions)
    def getDomainEndpointOptions: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.DomainEndpointOptions.ReadOnly
    ] =
      AwsError.unwrapOptionField("domainEndpointOptions", domainEndpointOptions)
    def getAdvancedSecurityOptions: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.AdvancedSecurityOptionsInput.ReadOnly
    ] = AwsError.unwrapOptionField(
      "advancedSecurityOptions",
      advancedSecurityOptions
    )
    def getAutoTuneOptions: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.AutoTuneOptionsInput.ReadOnly
    ] = AwsError.unwrapOptionField("autoTuneOptions", autoTuneOptions)
    def getTagList
        : ZIO[Any, AwsError, List[zio.aws.elasticsearch.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tagList", tagList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.CreateElasticsearchDomainRequest
  ) extends zio.aws.elasticsearch.model.CreateElasticsearchDomainRequest.ReadOnly {
    override val domainName: DomainName =
      zio.aws.elasticsearch.model.primitives.DomainName(impl.domainName())
    override val elasticsearchVersion: Option[ElasticsearchVersionString] =
      scala
        .Option(impl.elasticsearchVersion())
        .map(value =>
          zio.aws.elasticsearch.model.primitives
            .ElasticsearchVersionString(value)
        )
    override val elasticsearchClusterConfig: Option[
      zio.aws.elasticsearch.model.ElasticsearchClusterConfig.ReadOnly
    ] = scala
      .Option(impl.elasticsearchClusterConfig())
      .map(value =>
        zio.aws.elasticsearch.model.ElasticsearchClusterConfig.wrap(value)
      )
    override val ebsOptions
        : Option[zio.aws.elasticsearch.model.EBSOptions.ReadOnly] = scala
      .Option(impl.ebsOptions())
      .map(value => zio.aws.elasticsearch.model.EBSOptions.wrap(value))
    override val accessPolicies: Option[PolicyDocument] = scala
      .Option(impl.accessPolicies())
      .map(value =>
        zio.aws.elasticsearch.model.primitives.PolicyDocument(value)
      )
    override val snapshotOptions
        : Option[zio.aws.elasticsearch.model.SnapshotOptions.ReadOnly] = scala
      .Option(impl.snapshotOptions())
      .map(value => zio.aws.elasticsearch.model.SnapshotOptions.wrap(value))
    override val vpcOptions
        : Option[zio.aws.elasticsearch.model.VPCOptions.ReadOnly] = scala
      .Option(impl.vpcOptions())
      .map(value => zio.aws.elasticsearch.model.VPCOptions.wrap(value))
    override val cognitoOptions
        : Option[zio.aws.elasticsearch.model.CognitoOptions.ReadOnly] = scala
      .Option(impl.cognitoOptions())
      .map(value => zio.aws.elasticsearch.model.CognitoOptions.wrap(value))
    override val encryptionAtRestOptions
        : Option[zio.aws.elasticsearch.model.EncryptionAtRestOptions.ReadOnly] =
      scala
        .Option(impl.encryptionAtRestOptions())
        .map(value =>
          zio.aws.elasticsearch.model.EncryptionAtRestOptions.wrap(value)
        )
    override val nodeToNodeEncryptionOptions: Option[
      zio.aws.elasticsearch.model.NodeToNodeEncryptionOptions.ReadOnly
    ] = scala
      .Option(impl.nodeToNodeEncryptionOptions())
      .map(value =>
        zio.aws.elasticsearch.model.NodeToNodeEncryptionOptions.wrap(value)
      )
    override val advancedOptions: Option[Map[String, String]] = scala
      .Option(impl.advancedOptions())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val logPublishingOptions: Option[Map[
      zio.aws.elasticsearch.model.LogType,
      zio.aws.elasticsearch.model.LogPublishingOption.ReadOnly
    ]] = scala
      .Option(impl.logPublishingOptions())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.elasticsearch.model.LogType.wrap(
              key
            ) -> zio.aws.elasticsearch.model.LogPublishingOption.wrap(value)
          })
          .toMap
      )
    override val domainEndpointOptions
        : Option[zio.aws.elasticsearch.model.DomainEndpointOptions.ReadOnly] =
      scala
        .Option(impl.domainEndpointOptions())
        .map(value =>
          zio.aws.elasticsearch.model.DomainEndpointOptions.wrap(value)
        )
    override val advancedSecurityOptions: Option[
      zio.aws.elasticsearch.model.AdvancedSecurityOptionsInput.ReadOnly
    ] = scala
      .Option(impl.advancedSecurityOptions())
      .map(value =>
        zio.aws.elasticsearch.model.AdvancedSecurityOptionsInput.wrap(value)
      )
    override val autoTuneOptions
        : Option[zio.aws.elasticsearch.model.AutoTuneOptionsInput.ReadOnly] =
      scala
        .Option(impl.autoTuneOptions())
        .map(value =>
          zio.aws.elasticsearch.model.AutoTuneOptionsInput.wrap(value)
        )
    override val tagList
        : Option[List[zio.aws.elasticsearch.model.Tag.ReadOnly]] = scala
      .Option(impl.tagList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticsearch.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.CreateElasticsearchDomainRequest
  ): zio.aws.elasticsearch.model.CreateElasticsearchDomainRequest.ReadOnly =
    new Wrapper(impl)
}
