package zio.aws.elasticsearch.model
import zio.aws.elasticsearch.model.primitives.DomainName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteElasticsearchDomainRequest(domainName: DomainName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.DeleteElasticsearchDomainRequest = {
    import DeleteElasticsearchDomainRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.DeleteElasticsearchDomainRequest
      .builder()
      .domainName(DomainName.unwrap(domainName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.DeleteElasticsearchDomainRequest.ReadOnly =
    zio.aws.elasticsearch.model.DeleteElasticsearchDomainRequest
      .wrap(buildAwsValue())
}
object DeleteElasticsearchDomainRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.DeleteElasticsearchDomainRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticsearch.model.DeleteElasticsearchDomainRequest =
      zio.aws.elasticsearch.model.DeleteElasticsearchDomainRequest(domainName)
    def domainName: DomainName
    def getDomainName: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domainName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.DeleteElasticsearchDomainRequest
  ) extends zio.aws.elasticsearch.model.DeleteElasticsearchDomainRequest.ReadOnly {
    override val domainName: DomainName =
      zio.aws.elasticsearch.model.primitives.DomainName(impl.domainName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.DeleteElasticsearchDomainRequest
  ): zio.aws.elasticsearch.model.DeleteElasticsearchDomainRequest.ReadOnly =
    new Wrapper(impl)
}
