package zio.aws.elasticsearch.model
import zio.aws.elasticsearch.model.primitives.{LimitValue, LimitName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class StorageTypeLimit(
    limitName: Option[LimitName] = None,
    limitValues: Option[Iterable[LimitValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.StorageTypeLimit = {
    import StorageTypeLimit.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.StorageTypeLimit
      .builder()
      .optionallyWith(
        limitName.map(value => LimitName.unwrap(value): java.lang.String)
      )(_.limitName)
      .optionallyWith(
        limitValues.map(value =>
          value.map { item =>
            LimitValue.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.limitValues)
      .build()
  }
  def asReadOnly: zio.aws.elasticsearch.model.StorageTypeLimit.ReadOnly =
    zio.aws.elasticsearch.model.StorageTypeLimit.wrap(buildAwsValue())
}
object StorageTypeLimit {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.StorageTypeLimit
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.StorageTypeLimit =
      zio.aws.elasticsearch.model.StorageTypeLimit(
        limitName.map(value => value),
        limitValues.map(value => value)
      )
    def limitName: Option[LimitName]
    def limitValues: Option[List[LimitValue]]
    def getLimitName: ZIO[Any, AwsError, LimitName] =
      AwsError.unwrapOptionField("limitName", limitName)
    def getLimitValues: ZIO[Any, AwsError, List[LimitValue]] =
      AwsError.unwrapOptionField("limitValues", limitValues)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.StorageTypeLimit
  ) extends zio.aws.elasticsearch.model.StorageTypeLimit.ReadOnly {
    override val limitName: Option[LimitName] = scala
      .Option(impl.limitName())
      .map(value => zio.aws.elasticsearch.model.primitives.LimitName(value))
    override val limitValues: Option[List[LimitValue]] = scala
      .Option(impl.limitValues())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticsearch.model.primitives.LimitValue(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.StorageTypeLimit
  ): zio.aws.elasticsearch.model.StorageTypeLimit.ReadOnly = new Wrapper(impl)
}
