package zio.aws.elasticsearch.model
import zio.aws.elasticsearch.model.primitives.{
  ScheduledAutoTuneDescription,
  AutoTuneDate
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class ScheduledAutoTuneDetails(
    date: Option[AutoTuneDate] = None,
    actionType: Option[
      zio.aws.elasticsearch.model.ScheduledAutoTuneActionType
    ] = None,
    action: Option[ScheduledAutoTuneDescription] = None,
    severity: Option[
      zio.aws.elasticsearch.model.ScheduledAutoTuneSeverityType
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.ScheduledAutoTuneDetails = {
    import ScheduledAutoTuneDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.ScheduledAutoTuneDetails
      .builder()
      .optionallyWith(date.map(value => AutoTuneDate.unwrap(value): Instant))(
        _.date
      )
      .optionallyWith(actionType.map(value => value.unwrap))(_.actionType)
      .optionallyWith(
        action.map(value =>
          ScheduledAutoTuneDescription.unwrap(value): java.lang.String
        )
      )(_.action)
      .optionallyWith(severity.map(value => value.unwrap))(_.severity)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.ScheduledAutoTuneDetails.ReadOnly =
    zio.aws.elasticsearch.model.ScheduledAutoTuneDetails.wrap(buildAwsValue())
}
object ScheduledAutoTuneDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.ScheduledAutoTuneDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.ScheduledAutoTuneDetails =
      zio.aws.elasticsearch.model.ScheduledAutoTuneDetails(
        date.map(value => value),
        actionType.map(value => value),
        action.map(value => value),
        severity.map(value => value)
      )
    def date: Option[AutoTuneDate]
    def actionType
        : Option[zio.aws.elasticsearch.model.ScheduledAutoTuneActionType]
    def action: Option[ScheduledAutoTuneDescription]
    def severity
        : Option[zio.aws.elasticsearch.model.ScheduledAutoTuneSeverityType]
    def getDate: ZIO[Any, AwsError, AutoTuneDate] =
      AwsError.unwrapOptionField("date", date)
    def getActionType: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.ScheduledAutoTuneActionType
    ] = AwsError.unwrapOptionField("actionType", actionType)
    def getAction: ZIO[Any, AwsError, ScheduledAutoTuneDescription] =
      AwsError.unwrapOptionField("action", action)
    def getSeverity: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.ScheduledAutoTuneSeverityType
    ] = AwsError.unwrapOptionField("severity", severity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.ScheduledAutoTuneDetails
  ) extends zio.aws.elasticsearch.model.ScheduledAutoTuneDetails.ReadOnly {
    override val date: Option[AutoTuneDate] = scala
      .Option(impl.date())
      .map(value => zio.aws.elasticsearch.model.primitives.AutoTuneDate(value))
    override val actionType
        : Option[zio.aws.elasticsearch.model.ScheduledAutoTuneActionType] =
      scala
        .Option(impl.actionType())
        .map(value =>
          zio.aws.elasticsearch.model.ScheduledAutoTuneActionType.wrap(value)
        )
    override val action: Option[ScheduledAutoTuneDescription] = scala
      .Option(impl.action())
      .map(value =>
        zio.aws.elasticsearch.model.primitives
          .ScheduledAutoTuneDescription(value)
      )
    override val severity
        : Option[zio.aws.elasticsearch.model.ScheduledAutoTuneSeverityType] =
      scala
        .Option(impl.severity())
        .map(value =>
          zio.aws.elasticsearch.model.ScheduledAutoTuneSeverityType.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.ScheduledAutoTuneDetails
  ): zio.aws.elasticsearch.model.ScheduledAutoTuneDetails.ReadOnly =
    new Wrapper(impl)
}
