package zio.aws.elasticsearch.model
import java.lang.Integer
import zio.aws.elasticsearch.model.primitives.{
  MaximumInstanceCount,
  MinimumInstanceCount
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class InstanceCountLimits(
    minimumInstanceCount: Option[MinimumInstanceCount] = None,
    maximumInstanceCount: Option[MaximumInstanceCount] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.InstanceCountLimits = {
    import InstanceCountLimits.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.InstanceCountLimits
      .builder()
      .optionallyWith(
        minimumInstanceCount.map(value =>
          MinimumInstanceCount.unwrap(value): Integer
        )
      )(_.minimumInstanceCount)
      .optionallyWith(
        maximumInstanceCount.map(value =>
          MaximumInstanceCount.unwrap(value): Integer
        )
      )(_.maximumInstanceCount)
      .build()
  }
  def asReadOnly: zio.aws.elasticsearch.model.InstanceCountLimits.ReadOnly =
    zio.aws.elasticsearch.model.InstanceCountLimits.wrap(buildAwsValue())
}
object InstanceCountLimits {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.InstanceCountLimits
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.InstanceCountLimits =
      zio.aws.elasticsearch.model.InstanceCountLimits(
        minimumInstanceCount.map(value => value),
        maximumInstanceCount.map(value => value)
      )
    def minimumInstanceCount: Option[MinimumInstanceCount]
    def maximumInstanceCount: Option[MaximumInstanceCount]
    def getMinimumInstanceCount: ZIO[Any, AwsError, MinimumInstanceCount] =
      AwsError.unwrapOptionField("minimumInstanceCount", minimumInstanceCount)
    def getMaximumInstanceCount: ZIO[Any, AwsError, MaximumInstanceCount] =
      AwsError.unwrapOptionField("maximumInstanceCount", maximumInstanceCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.InstanceCountLimits
  ) extends zio.aws.elasticsearch.model.InstanceCountLimits.ReadOnly {
    override val minimumInstanceCount: Option[MinimumInstanceCount] = scala
      .Option(impl.minimumInstanceCount())
      .map(value =>
        zio.aws.elasticsearch.model.primitives.MinimumInstanceCount(value)
      )
    override val maximumInstanceCount: Option[MaximumInstanceCount] = scala
      .Option(impl.maximumInstanceCount())
      .map(value =>
        zio.aws.elasticsearch.model.primitives.MaximumInstanceCount(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.InstanceCountLimits
  ): zio.aws.elasticsearch.model.InstanceCountLimits.ReadOnly = new Wrapper(
    impl
  )
}
