package zio.aws.elasticsearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RejectInboundCrossClusterSearchConnectionResponse(
    crossClusterSearchConnection: Option[
      zio.aws.elasticsearch.model.InboundCrossClusterSearchConnection
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.RejectInboundCrossClusterSearchConnectionResponse = {
    import RejectInboundCrossClusterSearchConnectionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.RejectInboundCrossClusterSearchConnectionResponse
      .builder()
      .optionallyWith(
        crossClusterSearchConnection.map(value => value.buildAwsValue())
      )(_.crossClusterSearchConnection)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.RejectInboundCrossClusterSearchConnectionResponse.ReadOnly =
    zio.aws.elasticsearch.model.RejectInboundCrossClusterSearchConnectionResponse
      .wrap(buildAwsValue())
}
object RejectInboundCrossClusterSearchConnectionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.RejectInboundCrossClusterSearchConnectionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticsearch.model.RejectInboundCrossClusterSearchConnectionResponse =
      zio.aws.elasticsearch.model
        .RejectInboundCrossClusterSearchConnectionResponse(
          crossClusterSearchConnection.map(value => value.asEditable)
        )
    def crossClusterSearchConnection: Option[
      zio.aws.elasticsearch.model.InboundCrossClusterSearchConnection.ReadOnly
    ]
    def getCrossClusterSearchConnection: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.InboundCrossClusterSearchConnection.ReadOnly
    ] = AwsError.unwrapOptionField(
      "crossClusterSearchConnection",
      crossClusterSearchConnection
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.RejectInboundCrossClusterSearchConnectionResponse
  ) extends zio.aws.elasticsearch.model.RejectInboundCrossClusterSearchConnectionResponse.ReadOnly {
    override val crossClusterSearchConnection: Option[
      zio.aws.elasticsearch.model.InboundCrossClusterSearchConnection.ReadOnly
    ] = scala
      .Option(impl.crossClusterSearchConnection())
      .map(value =>
        zio.aws.elasticsearch.model.InboundCrossClusterSearchConnection
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.RejectInboundCrossClusterSearchConnectionResponse
  ): zio.aws.elasticsearch.model.RejectInboundCrossClusterSearchConnectionResponse.ReadOnly =
    new Wrapper(impl)
}
