package zio.aws.elasticsearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeReservedElasticsearchInstancesResponse(
    nextToken: Option[String] = None,
    reservedElasticsearchInstances: Option[
      Iterable[zio.aws.elasticsearch.model.ReservedElasticsearchInstance]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstancesResponse = {
    import DescribeReservedElasticsearchInstancesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstancesResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        reservedElasticsearchInstances.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.reservedElasticsearchInstances)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.DescribeReservedElasticsearchInstancesResponse.ReadOnly =
    zio.aws.elasticsearch.model.DescribeReservedElasticsearchInstancesResponse
      .wrap(buildAwsValue())
}
object DescribeReservedElasticsearchInstancesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstancesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticsearch.model.DescribeReservedElasticsearchInstancesResponse =
      zio.aws.elasticsearch.model
        .DescribeReservedElasticsearchInstancesResponse(
          nextToken.map(value => value),
          reservedElasticsearchInstances.map(value =>
            value.map { item =>
              item.asEditable
            }
          )
        )
    def nextToken: Option[String]
    def reservedElasticsearchInstances: Option[
      List[zio.aws.elasticsearch.model.ReservedElasticsearchInstance.ReadOnly]
    ]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getReservedElasticsearchInstances: ZIO[Any, AwsError, List[
      zio.aws.elasticsearch.model.ReservedElasticsearchInstance.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "reservedElasticsearchInstances",
      reservedElasticsearchInstances
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstancesResponse
  ) extends zio.aws.elasticsearch.model.DescribeReservedElasticsearchInstancesResponse.ReadOnly {
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val reservedElasticsearchInstances: Option[
      List[zio.aws.elasticsearch.model.ReservedElasticsearchInstance.ReadOnly]
    ] = scala
      .Option(impl.reservedElasticsearchInstances())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticsearch.model.ReservedElasticsearchInstance.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstancesResponse
  ): zio.aws.elasticsearch.model.DescribeReservedElasticsearchInstancesResponse.ReadOnly =
    new Wrapper(impl)
}
