package zio.aws.elasticsearch.model
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.elasticsearch.model.primitives.{
  TotalNumberOfStages,
  UpdateTimestamp,
  GUID
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ChangeProgressStatusDetails(
    changeId: Option[GUID] = None,
    startTime: Option[UpdateTimestamp] = None,
    status: Option[zio.aws.elasticsearch.model.OverallChangeStatus] = None,
    pendingProperties: Option[Iterable[String]] = None,
    completedProperties: Option[Iterable[String]] = None,
    totalNumberOfStages: Option[TotalNumberOfStages] = None,
    changeProgressStages: Option[
      Iterable[zio.aws.elasticsearch.model.ChangeProgressStage]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.ChangeProgressStatusDetails = {
    import ChangeProgressStatusDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.ChangeProgressStatusDetails
      .builder()
      .optionallyWith(
        changeId.map(value => GUID.unwrap(value): java.lang.String)
      )(_.changeId)
      .optionallyWith(
        startTime.map(value => UpdateTimestamp.unwrap(value): Instant)
      )(_.startTime)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        pendingProperties.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.pendingProperties)
      .optionallyWith(
        completedProperties.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.completedProperties)
      .optionallyWith(
        totalNumberOfStages.map(value =>
          TotalNumberOfStages.unwrap(value): Integer
        )
      )(_.totalNumberOfStages)
      .optionallyWith(
        changeProgressStages.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.changeProgressStages)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.ChangeProgressStatusDetails.ReadOnly =
    zio.aws.elasticsearch.model.ChangeProgressStatusDetails
      .wrap(buildAwsValue())
}
object ChangeProgressStatusDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.ChangeProgressStatusDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.ChangeProgressStatusDetails =
      zio.aws.elasticsearch.model.ChangeProgressStatusDetails(
        changeId.map(value => value),
        startTime.map(value => value),
        status.map(value => value),
        pendingProperties.map(value => value),
        completedProperties.map(value => value),
        totalNumberOfStages.map(value => value),
        changeProgressStages.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def changeId: Option[GUID]
    def startTime: Option[UpdateTimestamp]
    def status: Option[zio.aws.elasticsearch.model.OverallChangeStatus]
    def pendingProperties: Option[List[String]]
    def completedProperties: Option[List[String]]
    def totalNumberOfStages: Option[TotalNumberOfStages]
    def changeProgressStages
        : Option[List[zio.aws.elasticsearch.model.ChangeProgressStage.ReadOnly]]
    def getChangeId: ZIO[Any, AwsError, GUID] =
      AwsError.unwrapOptionField("changeId", changeId)
    def getStartTime: ZIO[Any, AwsError, UpdateTimestamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.elasticsearch.model.OverallChangeStatus] =
      AwsError.unwrapOptionField("status", status)
    def getPendingProperties: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("pendingProperties", pendingProperties)
    def getCompletedProperties: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("completedProperties", completedProperties)
    def getTotalNumberOfStages: ZIO[Any, AwsError, TotalNumberOfStages] =
      AwsError.unwrapOptionField("totalNumberOfStages", totalNumberOfStages)
    def getChangeProgressStages: ZIO[Any, AwsError, List[
      zio.aws.elasticsearch.model.ChangeProgressStage.ReadOnly
    ]] =
      AwsError.unwrapOptionField("changeProgressStages", changeProgressStages)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.ChangeProgressStatusDetails
  ) extends zio.aws.elasticsearch.model.ChangeProgressStatusDetails.ReadOnly {
    override val changeId: Option[GUID] = scala
      .Option(impl.changeId())
      .map(value => zio.aws.elasticsearch.model.primitives.GUID(value))
    override val startTime: Option[UpdateTimestamp] = scala
      .Option(impl.startTime())
      .map(value =>
        zio.aws.elasticsearch.model.primitives.UpdateTimestamp(value)
      )
    override val status
        : Option[zio.aws.elasticsearch.model.OverallChangeStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.elasticsearch.model.OverallChangeStatus.wrap(value))
    override val pendingProperties: Option[List[String]] = scala
      .Option(impl.pendingProperties())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val completedProperties: Option[List[String]] = scala
      .Option(impl.completedProperties())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val totalNumberOfStages: Option[TotalNumberOfStages] = scala
      .Option(impl.totalNumberOfStages())
      .map(value =>
        zio.aws.elasticsearch.model.primitives.TotalNumberOfStages(value)
      )
    override val changeProgressStages: Option[
      List[zio.aws.elasticsearch.model.ChangeProgressStage.ReadOnly]
    ] = scala
      .Option(impl.changeProgressStages())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticsearch.model.ChangeProgressStage.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.ChangeProgressStatusDetails
  ): zio.aws.elasticsearch.model.ChangeProgressStatusDetails.ReadOnly =
    new Wrapper(impl)
}
