package zio.aws.elasticsearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AutoTuneOptionsOutput(
    state: Option[zio.aws.elasticsearch.model.AutoTuneState] = None,
    errorMessage: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.AutoTuneOptionsOutput = {
    import AutoTuneOptionsOutput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.AutoTuneOptionsOutput
      .builder()
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(errorMessage.map(value => value: java.lang.String))(
        _.errorMessage
      )
      .build()
  }
  def asReadOnly: zio.aws.elasticsearch.model.AutoTuneOptionsOutput.ReadOnly =
    zio.aws.elasticsearch.model.AutoTuneOptionsOutput.wrap(buildAwsValue())
}
object AutoTuneOptionsOutput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.AutoTuneOptionsOutput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.AutoTuneOptionsOutput =
      zio.aws.elasticsearch.model.AutoTuneOptionsOutput(
        state.map(value => value),
        errorMessage.map(value => value)
      )
    def state: Option[zio.aws.elasticsearch.model.AutoTuneState]
    def errorMessage: Option[String]
    def getState
        : ZIO[Any, AwsError, zio.aws.elasticsearch.model.AutoTuneState] =
      AwsError.unwrapOptionField("state", state)
    def getErrorMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.AutoTuneOptionsOutput
  ) extends zio.aws.elasticsearch.model.AutoTuneOptionsOutput.ReadOnly {
    override val state: Option[zio.aws.elasticsearch.model.AutoTuneState] =
      scala
        .Option(impl.state())
        .map(value => zio.aws.elasticsearch.model.AutoTuneState.wrap(value))
    override val errorMessage: Option[String] =
      scala.Option(impl.errorMessage()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.AutoTuneOptionsOutput
  ): zio.aws.elasticsearch.model.AutoTuneOptionsOutput.ReadOnly = new Wrapper(
    impl
  )
}
