package zio.aws.elasticsearch.model
import zio.aws.elasticsearch.model.primitives.CloudWatchLogsLogGroupArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class LogPublishingOption(
    cloudWatchLogsLogGroupArn: Option[CloudWatchLogsLogGroupArn] = None,
    enabled: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.LogPublishingOption = {
    import LogPublishingOption.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.LogPublishingOption
      .builder()
      .optionallyWith(
        cloudWatchLogsLogGroupArn.map(value =>
          CloudWatchLogsLogGroupArn.unwrap(value): java.lang.String
        )
      )(_.cloudWatchLogsLogGroupArn)
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .build()
  }
  def asReadOnly: zio.aws.elasticsearch.model.LogPublishingOption.ReadOnly =
    zio.aws.elasticsearch.model.LogPublishingOption.wrap(buildAwsValue())
}
object LogPublishingOption {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.LogPublishingOption
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.LogPublishingOption =
      zio.aws.elasticsearch.model.LogPublishingOption(
        cloudWatchLogsLogGroupArn.map(value => value),
        enabled.map(value => value)
      )
    def cloudWatchLogsLogGroupArn: Option[CloudWatchLogsLogGroupArn]
    def enabled: Option[Boolean]
    def getCloudWatchLogsLogGroupArn
        : ZIO[Any, AwsError, CloudWatchLogsLogGroupArn] = AwsError
      .unwrapOptionField("cloudWatchLogsLogGroupArn", cloudWatchLogsLogGroupArn)
    def getEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.LogPublishingOption
  ) extends zio.aws.elasticsearch.model.LogPublishingOption.ReadOnly {
    override val cloudWatchLogsLogGroupArn: Option[CloudWatchLogsLogGroupArn] =
      scala
        .Option(impl.cloudWatchLogsLogGroupArn())
        .map(value =>
          zio.aws.elasticsearch.model.primitives
            .CloudWatchLogsLogGroupArn(value)
        )
    override val enabled: Option[Boolean] =
      scala.Option(impl.enabled()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.LogPublishingOption
  ): zio.aws.elasticsearch.model.LogPublishingOption.ReadOnly = new Wrapper(
    impl
  )
}
