package zio.aws.elasticsearch.model
import java.lang.Integer
import zio.aws.elasticsearch.model.primitives.{
  NextToken,
  MaxResults,
  DomainName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetUpgradeHistoryRequest(
    domainName: DomainName,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.GetUpgradeHistoryRequest = {
    import GetUpgradeHistoryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.GetUpgradeHistoryRequest
      .builder()
      .domainName(DomainName.unwrap(domainName): java.lang.String)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.GetUpgradeHistoryRequest.ReadOnly =
    zio.aws.elasticsearch.model.GetUpgradeHistoryRequest.wrap(buildAwsValue())
}
object GetUpgradeHistoryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.GetUpgradeHistoryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.GetUpgradeHistoryRequest =
      zio.aws.elasticsearch.model.GetUpgradeHistoryRequest(
        domainName,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def domainName: DomainName
    def maxResults: Option[MaxResults]
    def nextToken: Option[NextToken]
    def getDomainName: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domainName)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.GetUpgradeHistoryRequest
  ) extends zio.aws.elasticsearch.model.GetUpgradeHistoryRequest.ReadOnly {
    override val domainName: DomainName =
      zio.aws.elasticsearch.model.primitives.DomainName(impl.domainName())
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.elasticsearch.model.primitives.MaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.elasticsearch.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.GetUpgradeHistoryRequest
  ): zio.aws.elasticsearch.model.GetUpgradeHistoryRequest.ReadOnly =
    new Wrapper(impl)
}
