package zio.aws.elasticsearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ElasticsearchDomainConfig(
    elasticsearchVersion: Option[
      zio.aws.elasticsearch.model.ElasticsearchVersionStatus
    ] = None,
    elasticsearchClusterConfig: Option[
      zio.aws.elasticsearch.model.ElasticsearchClusterConfigStatus
    ] = None,
    ebsOptions: Option[zio.aws.elasticsearch.model.EBSOptionsStatus] = None,
    accessPolicies: Option[zio.aws.elasticsearch.model.AccessPoliciesStatus] =
      None,
    snapshotOptions: Option[zio.aws.elasticsearch.model.SnapshotOptionsStatus] =
      None,
    vpcOptions: Option[zio.aws.elasticsearch.model.VPCDerivedInfoStatus] = None,
    cognitoOptions: Option[zio.aws.elasticsearch.model.CognitoOptionsStatus] =
      None,
    encryptionAtRestOptions: Option[
      zio.aws.elasticsearch.model.EncryptionAtRestOptionsStatus
    ] = None,
    nodeToNodeEncryptionOptions: Option[
      zio.aws.elasticsearch.model.NodeToNodeEncryptionOptionsStatus
    ] = None,
    advancedOptions: Option[zio.aws.elasticsearch.model.AdvancedOptionsStatus] =
      None,
    logPublishingOptions: Option[
      zio.aws.elasticsearch.model.LogPublishingOptionsStatus
    ] = None,
    domainEndpointOptions: Option[
      zio.aws.elasticsearch.model.DomainEndpointOptionsStatus
    ] = None,
    advancedSecurityOptions: Option[
      zio.aws.elasticsearch.model.AdvancedSecurityOptionsStatus
    ] = None,
    autoTuneOptions: Option[zio.aws.elasticsearch.model.AutoTuneOptionsStatus] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.ElasticsearchDomainConfig = {
    import ElasticsearchDomainConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.ElasticsearchDomainConfig
      .builder()
      .optionallyWith(elasticsearchVersion.map(value => value.buildAwsValue()))(
        _.elasticsearchVersion
      )
      .optionallyWith(
        elasticsearchClusterConfig.map(value => value.buildAwsValue())
      )(_.elasticsearchClusterConfig)
      .optionallyWith(ebsOptions.map(value => value.buildAwsValue()))(
        _.ebsOptions
      )
      .optionallyWith(accessPolicies.map(value => value.buildAwsValue()))(
        _.accessPolicies
      )
      .optionallyWith(snapshotOptions.map(value => value.buildAwsValue()))(
        _.snapshotOptions
      )
      .optionallyWith(vpcOptions.map(value => value.buildAwsValue()))(
        _.vpcOptions
      )
      .optionallyWith(cognitoOptions.map(value => value.buildAwsValue()))(
        _.cognitoOptions
      )
      .optionallyWith(
        encryptionAtRestOptions.map(value => value.buildAwsValue())
      )(_.encryptionAtRestOptions)
      .optionallyWith(
        nodeToNodeEncryptionOptions.map(value => value.buildAwsValue())
      )(_.nodeToNodeEncryptionOptions)
      .optionallyWith(advancedOptions.map(value => value.buildAwsValue()))(
        _.advancedOptions
      )
      .optionallyWith(logPublishingOptions.map(value => value.buildAwsValue()))(
        _.logPublishingOptions
      )
      .optionallyWith(
        domainEndpointOptions.map(value => value.buildAwsValue())
      )(_.domainEndpointOptions)
      .optionallyWith(
        advancedSecurityOptions.map(value => value.buildAwsValue())
      )(_.advancedSecurityOptions)
      .optionallyWith(autoTuneOptions.map(value => value.buildAwsValue()))(
        _.autoTuneOptions
      )
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.ElasticsearchDomainConfig.ReadOnly =
    zio.aws.elasticsearch.model.ElasticsearchDomainConfig.wrap(buildAwsValue())
}
object ElasticsearchDomainConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.ElasticsearchDomainConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.ElasticsearchDomainConfig =
      zio.aws.elasticsearch.model.ElasticsearchDomainConfig(
        elasticsearchVersion.map(value => value.asEditable),
        elasticsearchClusterConfig.map(value => value.asEditable),
        ebsOptions.map(value => value.asEditable),
        accessPolicies.map(value => value.asEditable),
        snapshotOptions.map(value => value.asEditable),
        vpcOptions.map(value => value.asEditable),
        cognitoOptions.map(value => value.asEditable),
        encryptionAtRestOptions.map(value => value.asEditable),
        nodeToNodeEncryptionOptions.map(value => value.asEditable),
        advancedOptions.map(value => value.asEditable),
        logPublishingOptions.map(value => value.asEditable),
        domainEndpointOptions.map(value => value.asEditable),
        advancedSecurityOptions.map(value => value.asEditable),
        autoTuneOptions.map(value => value.asEditable)
      )
    def elasticsearchVersion: Option[
      zio.aws.elasticsearch.model.ElasticsearchVersionStatus.ReadOnly
    ]
    def elasticsearchClusterConfig: Option[
      zio.aws.elasticsearch.model.ElasticsearchClusterConfigStatus.ReadOnly
    ]
    def ebsOptions
        : Option[zio.aws.elasticsearch.model.EBSOptionsStatus.ReadOnly]
    def accessPolicies
        : Option[zio.aws.elasticsearch.model.AccessPoliciesStatus.ReadOnly]
    def snapshotOptions
        : Option[zio.aws.elasticsearch.model.SnapshotOptionsStatus.ReadOnly]
    def vpcOptions
        : Option[zio.aws.elasticsearch.model.VPCDerivedInfoStatus.ReadOnly]
    def cognitoOptions
        : Option[zio.aws.elasticsearch.model.CognitoOptionsStatus.ReadOnly]
    def encryptionAtRestOptions: Option[
      zio.aws.elasticsearch.model.EncryptionAtRestOptionsStatus.ReadOnly
    ]
    def nodeToNodeEncryptionOptions: Option[
      zio.aws.elasticsearch.model.NodeToNodeEncryptionOptionsStatus.ReadOnly
    ]
    def advancedOptions
        : Option[zio.aws.elasticsearch.model.AdvancedOptionsStatus.ReadOnly]
    def logPublishingOptions: Option[
      zio.aws.elasticsearch.model.LogPublishingOptionsStatus.ReadOnly
    ]
    def domainEndpointOptions: Option[
      zio.aws.elasticsearch.model.DomainEndpointOptionsStatus.ReadOnly
    ]
    def advancedSecurityOptions: Option[
      zio.aws.elasticsearch.model.AdvancedSecurityOptionsStatus.ReadOnly
    ]
    def autoTuneOptions
        : Option[zio.aws.elasticsearch.model.AutoTuneOptionsStatus.ReadOnly]
    def getElasticsearchVersion: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.ElasticsearchVersionStatus.ReadOnly
    ] = AwsError.unwrapOptionField("elasticsearchVersion", elasticsearchVersion)
    def getElasticsearchClusterConfig: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.ElasticsearchClusterConfigStatus.ReadOnly
    ] = AwsError.unwrapOptionField(
      "elasticsearchClusterConfig",
      elasticsearchClusterConfig
    )
    def getEbsOptions: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.EBSOptionsStatus.ReadOnly
    ] = AwsError.unwrapOptionField("ebsOptions", ebsOptions)
    def getAccessPolicies: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.AccessPoliciesStatus.ReadOnly
    ] = AwsError.unwrapOptionField("accessPolicies", accessPolicies)
    def getSnapshotOptions: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.SnapshotOptionsStatus.ReadOnly
    ] = AwsError.unwrapOptionField("snapshotOptions", snapshotOptions)
    def getVpcOptions: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.VPCDerivedInfoStatus.ReadOnly
    ] = AwsError.unwrapOptionField("vpcOptions", vpcOptions)
    def getCognitoOptions: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.CognitoOptionsStatus.ReadOnly
    ] = AwsError.unwrapOptionField("cognitoOptions", cognitoOptions)
    def getEncryptionAtRestOptions: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.EncryptionAtRestOptionsStatus.ReadOnly
    ] = AwsError.unwrapOptionField(
      "encryptionAtRestOptions",
      encryptionAtRestOptions
    )
    def getNodeToNodeEncryptionOptions: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.NodeToNodeEncryptionOptionsStatus.ReadOnly
    ] = AwsError.unwrapOptionField(
      "nodeToNodeEncryptionOptions",
      nodeToNodeEncryptionOptions
    )
    def getAdvancedOptions: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.AdvancedOptionsStatus.ReadOnly
    ] = AwsError.unwrapOptionField("advancedOptions", advancedOptions)
    def getLogPublishingOptions: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.LogPublishingOptionsStatus.ReadOnly
    ] = AwsError.unwrapOptionField("logPublishingOptions", logPublishingOptions)
    def getDomainEndpointOptions: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.DomainEndpointOptionsStatus.ReadOnly
    ] =
      AwsError.unwrapOptionField("domainEndpointOptions", domainEndpointOptions)
    def getAdvancedSecurityOptions: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.AdvancedSecurityOptionsStatus.ReadOnly
    ] = AwsError.unwrapOptionField(
      "advancedSecurityOptions",
      advancedSecurityOptions
    )
    def getAutoTuneOptions: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.AutoTuneOptionsStatus.ReadOnly
    ] = AwsError.unwrapOptionField("autoTuneOptions", autoTuneOptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.ElasticsearchDomainConfig
  ) extends zio.aws.elasticsearch.model.ElasticsearchDomainConfig.ReadOnly {
    override val elasticsearchVersion: Option[
      zio.aws.elasticsearch.model.ElasticsearchVersionStatus.ReadOnly
    ] = scala
      .Option(impl.elasticsearchVersion())
      .map(value =>
        zio.aws.elasticsearch.model.ElasticsearchVersionStatus.wrap(value)
      )
    override val elasticsearchClusterConfig: Option[
      zio.aws.elasticsearch.model.ElasticsearchClusterConfigStatus.ReadOnly
    ] = scala
      .Option(impl.elasticsearchClusterConfig())
      .map(value =>
        zio.aws.elasticsearch.model.ElasticsearchClusterConfigStatus.wrap(value)
      )
    override val ebsOptions
        : Option[zio.aws.elasticsearch.model.EBSOptionsStatus.ReadOnly] = scala
      .Option(impl.ebsOptions())
      .map(value => zio.aws.elasticsearch.model.EBSOptionsStatus.wrap(value))
    override val accessPolicies
        : Option[zio.aws.elasticsearch.model.AccessPoliciesStatus.ReadOnly] =
      scala
        .Option(impl.accessPolicies())
        .map(value =>
          zio.aws.elasticsearch.model.AccessPoliciesStatus.wrap(value)
        )
    override val snapshotOptions
        : Option[zio.aws.elasticsearch.model.SnapshotOptionsStatus.ReadOnly] =
      scala
        .Option(impl.snapshotOptions())
        .map(value =>
          zio.aws.elasticsearch.model.SnapshotOptionsStatus.wrap(value)
        )
    override val vpcOptions
        : Option[zio.aws.elasticsearch.model.VPCDerivedInfoStatus.ReadOnly] =
      scala
        .Option(impl.vpcOptions())
        .map(value =>
          zio.aws.elasticsearch.model.VPCDerivedInfoStatus.wrap(value)
        )
    override val cognitoOptions
        : Option[zio.aws.elasticsearch.model.CognitoOptionsStatus.ReadOnly] =
      scala
        .Option(impl.cognitoOptions())
        .map(value =>
          zio.aws.elasticsearch.model.CognitoOptionsStatus.wrap(value)
        )
    override val encryptionAtRestOptions: Option[
      zio.aws.elasticsearch.model.EncryptionAtRestOptionsStatus.ReadOnly
    ] = scala
      .Option(impl.encryptionAtRestOptions())
      .map(value =>
        zio.aws.elasticsearch.model.EncryptionAtRestOptionsStatus.wrap(value)
      )
    override val nodeToNodeEncryptionOptions: Option[
      zio.aws.elasticsearch.model.NodeToNodeEncryptionOptionsStatus.ReadOnly
    ] = scala
      .Option(impl.nodeToNodeEncryptionOptions())
      .map(value =>
        zio.aws.elasticsearch.model.NodeToNodeEncryptionOptionsStatus
          .wrap(value)
      )
    override val advancedOptions
        : Option[zio.aws.elasticsearch.model.AdvancedOptionsStatus.ReadOnly] =
      scala
        .Option(impl.advancedOptions())
        .map(value =>
          zio.aws.elasticsearch.model.AdvancedOptionsStatus.wrap(value)
        )
    override val logPublishingOptions: Option[
      zio.aws.elasticsearch.model.LogPublishingOptionsStatus.ReadOnly
    ] = scala
      .Option(impl.logPublishingOptions())
      .map(value =>
        zio.aws.elasticsearch.model.LogPublishingOptionsStatus.wrap(value)
      )
    override val domainEndpointOptions: Option[
      zio.aws.elasticsearch.model.DomainEndpointOptionsStatus.ReadOnly
    ] = scala
      .Option(impl.domainEndpointOptions())
      .map(value =>
        zio.aws.elasticsearch.model.DomainEndpointOptionsStatus.wrap(value)
      )
    override val advancedSecurityOptions: Option[
      zio.aws.elasticsearch.model.AdvancedSecurityOptionsStatus.ReadOnly
    ] = scala
      .Option(impl.advancedSecurityOptions())
      .map(value =>
        zio.aws.elasticsearch.model.AdvancedSecurityOptionsStatus.wrap(value)
      )
    override val autoTuneOptions
        : Option[zio.aws.elasticsearch.model.AutoTuneOptionsStatus.ReadOnly] =
      scala
        .Option(impl.autoTuneOptions())
        .map(value =>
          zio.aws.elasticsearch.model.AutoTuneOptionsStatus.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.ElasticsearchDomainConfig
  ): zio.aws.elasticsearch.model.ElasticsearchDomainConfig.ReadOnly =
    new Wrapper(impl)
}
