package zio.aws.elasticsearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribePackagesResponse(
    packageDetailsList: Option[
      Iterable[zio.aws.elasticsearch.model.PackageDetails]
    ] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.DescribePackagesResponse = {
    import DescribePackagesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.DescribePackagesResponse
      .builder()
      .optionallyWith(
        packageDetailsList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.packageDetailsList)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.DescribePackagesResponse.ReadOnly =
    zio.aws.elasticsearch.model.DescribePackagesResponse.wrap(buildAwsValue())
}
object DescribePackagesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.DescribePackagesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.DescribePackagesResponse =
      zio.aws.elasticsearch.model.DescribePackagesResponse(
        packageDetailsList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def packageDetailsList
        : Option[List[zio.aws.elasticsearch.model.PackageDetails.ReadOnly]]
    def nextToken: Option[String]
    def getPackageDetailsList: ZIO[Any, AwsError, List[
      zio.aws.elasticsearch.model.PackageDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("packageDetailsList", packageDetailsList)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.DescribePackagesResponse
  ) extends zio.aws.elasticsearch.model.DescribePackagesResponse.ReadOnly {
    override val packageDetailsList
        : Option[List[zio.aws.elasticsearch.model.PackageDetails.ReadOnly]] =
      scala
        .Option(impl.packageDetailsList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticsearch.model.PackageDetails.wrap(item)
          }.toList
        )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.DescribePackagesResponse
  ): zio.aws.elasticsearch.model.DescribePackagesResponse.ReadOnly =
    new Wrapper(impl)
}
