package zio.aws.elasticsearch.model
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.elasticsearch.model.primitives.{UIntValue, UpdateTimestamp}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class OptionStatus(
    creationDate: UpdateTimestamp,
    updateDate: UpdateTimestamp,
    updateVersion: Option[UIntValue] = None,
    state: zio.aws.elasticsearch.model.OptionState,
    pendingDeletion: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.OptionStatus = {
    import OptionStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.OptionStatus
      .builder()
      .creationDate(UpdateTimestamp.unwrap(creationDate): Instant)
      .updateDate(UpdateTimestamp.unwrap(updateDate): Instant)
      .optionallyWith(
        updateVersion.map(value => UIntValue.unwrap(value): Integer)
      )(_.updateVersion)
      .state(state.unwrap)
      .optionallyWith(pendingDeletion.map(value => value: java.lang.Boolean))(
        _.pendingDeletion
      )
      .build()
  }
  def asReadOnly: zio.aws.elasticsearch.model.OptionStatus.ReadOnly =
    zio.aws.elasticsearch.model.OptionStatus.wrap(buildAwsValue())
}
object OptionStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.OptionStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.OptionStatus =
      zio.aws.elasticsearch.model.OptionStatus(
        creationDate,
        updateDate,
        updateVersion.map(value => value),
        state,
        pendingDeletion.map(value => value)
      )
    def creationDate: UpdateTimestamp
    def updateDate: UpdateTimestamp
    def updateVersion: Option[UIntValue]
    def state: zio.aws.elasticsearch.model.OptionState
    def pendingDeletion: Option[Boolean]
    def getCreationDate: ZIO[Any, Nothing, UpdateTimestamp] =
      ZIO.succeed(creationDate)
    def getUpdateDate: ZIO[Any, Nothing, UpdateTimestamp] =
      ZIO.succeed(updateDate)
    def getUpdateVersion: ZIO[Any, AwsError, UIntValue] =
      AwsError.unwrapOptionField("updateVersion", updateVersion)
    def getState: ZIO[Any, Nothing, zio.aws.elasticsearch.model.OptionState] =
      ZIO.succeed(state)
    def getPendingDeletion: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("pendingDeletion", pendingDeletion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.OptionStatus
  ) extends zio.aws.elasticsearch.model.OptionStatus.ReadOnly {
    override val creationDate: UpdateTimestamp =
      zio.aws.elasticsearch.model.primitives
        .UpdateTimestamp(impl.creationDate())
    override val updateDate: UpdateTimestamp =
      zio.aws.elasticsearch.model.primitives.UpdateTimestamp(impl.updateDate())
    override val updateVersion: Option[UIntValue] = scala
      .Option(impl.updateVersion())
      .map(value => zio.aws.elasticsearch.model.primitives.UIntValue(value))
    override val state: zio.aws.elasticsearch.model.OptionState =
      zio.aws.elasticsearch.model.OptionState.wrap(impl.state())
    override val pendingDeletion: Option[Boolean] =
      scala.Option(impl.pendingDeletion()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.OptionStatus
  ): zio.aws.elasticsearch.model.OptionStatus.ReadOnly = new Wrapper(impl)
}
