package zio.aws.elasticsearch.model
import zio.aws.elasticsearch.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeInboundCrossClusterSearchConnectionsResponse(
    crossClusterSearchConnections: Option[
      Iterable[zio.aws.elasticsearch.model.InboundCrossClusterSearchConnection]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.DescribeInboundCrossClusterSearchConnectionsResponse = {
    import DescribeInboundCrossClusterSearchConnectionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.DescribeInboundCrossClusterSearchConnectionsResponse
      .builder()
      .optionallyWith(
        crossClusterSearchConnections.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.crossClusterSearchConnections)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.DescribeInboundCrossClusterSearchConnectionsResponse.ReadOnly =
    zio.aws.elasticsearch.model.DescribeInboundCrossClusterSearchConnectionsResponse
      .wrap(buildAwsValue())
}
object DescribeInboundCrossClusterSearchConnectionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.DescribeInboundCrossClusterSearchConnectionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticsearch.model.DescribeInboundCrossClusterSearchConnectionsResponse =
      zio.aws.elasticsearch.model
        .DescribeInboundCrossClusterSearchConnectionsResponse(
          crossClusterSearchConnections.map(value =>
            value.map { item =>
              item.asEditable
            }
          ),
          nextToken.map(value => value)
        )
    def crossClusterSearchConnections: Option[List[
      zio.aws.elasticsearch.model.InboundCrossClusterSearchConnection.ReadOnly
    ]]
    def nextToken: Option[NextToken]
    def getCrossClusterSearchConnections: ZIO[Any, AwsError, List[
      zio.aws.elasticsearch.model.InboundCrossClusterSearchConnection.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "crossClusterSearchConnections",
      crossClusterSearchConnections
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.DescribeInboundCrossClusterSearchConnectionsResponse
  ) extends zio.aws.elasticsearch.model.DescribeInboundCrossClusterSearchConnectionsResponse.ReadOnly {
    override val crossClusterSearchConnections: Option[List[
      zio.aws.elasticsearch.model.InboundCrossClusterSearchConnection.ReadOnly
    ]] = scala
      .Option(impl.crossClusterSearchConnections())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticsearch.model.InboundCrossClusterSearchConnection
            .wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.elasticsearch.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.DescribeInboundCrossClusterSearchConnectionsResponse
  ): zio.aws.elasticsearch.model.DescribeInboundCrossClusterSearchConnectionsResponse.ReadOnly =
    new Wrapper(impl)
}
