package zio.aws.elasticsearch.model
import zio.aws.elasticsearch.model.primitives.{ARN, DomainNameFqdn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DomainEndpointOptions(
    enforceHTTPS: Option[Boolean] = None,
    tlsSecurityPolicy: Option[zio.aws.elasticsearch.model.TLSSecurityPolicy] =
      None,
    customEndpointEnabled: Option[Boolean] = None,
    customEndpoint: Option[DomainNameFqdn] = None,
    customEndpointCertificateArn: Option[ARN] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.DomainEndpointOptions = {
    import DomainEndpointOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.DomainEndpointOptions
      .builder()
      .optionallyWith(enforceHTTPS.map(value => value: java.lang.Boolean))(
        _.enforceHTTPS
      )
      .optionallyWith(tlsSecurityPolicy.map(value => value.unwrap))(
        _.tlsSecurityPolicy
      )
      .optionallyWith(
        customEndpointEnabled.map(value => value: java.lang.Boolean)
      )(_.customEndpointEnabled)
      .optionallyWith(
        customEndpoint.map(value =>
          DomainNameFqdn.unwrap(value): java.lang.String
        )
      )(_.customEndpoint)
      .optionallyWith(
        customEndpointCertificateArn.map(value =>
          ARN.unwrap(value): java.lang.String
        )
      )(_.customEndpointCertificateArn)
      .build()
  }
  def asReadOnly: zio.aws.elasticsearch.model.DomainEndpointOptions.ReadOnly =
    zio.aws.elasticsearch.model.DomainEndpointOptions.wrap(buildAwsValue())
}
object DomainEndpointOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.DomainEndpointOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.DomainEndpointOptions =
      zio.aws.elasticsearch.model.DomainEndpointOptions(
        enforceHTTPS.map(value => value),
        tlsSecurityPolicy.map(value => value),
        customEndpointEnabled.map(value => value),
        customEndpoint.map(value => value),
        customEndpointCertificateArn.map(value => value)
      )
    def enforceHTTPS: Option[Boolean]
    def tlsSecurityPolicy: Option[zio.aws.elasticsearch.model.TLSSecurityPolicy]
    def customEndpointEnabled: Option[Boolean]
    def customEndpoint: Option[DomainNameFqdn]
    def customEndpointCertificateArn: Option[ARN]
    def getEnforceHTTPS: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enforceHTTPS", enforceHTTPS)
    def getTlsSecurityPolicy
        : ZIO[Any, AwsError, zio.aws.elasticsearch.model.TLSSecurityPolicy] =
      AwsError.unwrapOptionField("tlsSecurityPolicy", tlsSecurityPolicy)
    def getCustomEndpointEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("customEndpointEnabled", customEndpointEnabled)
    def getCustomEndpoint: ZIO[Any, AwsError, DomainNameFqdn] =
      AwsError.unwrapOptionField("customEndpoint", customEndpoint)
    def getCustomEndpointCertificateArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField(
        "customEndpointCertificateArn",
        customEndpointCertificateArn
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.DomainEndpointOptions
  ) extends zio.aws.elasticsearch.model.DomainEndpointOptions.ReadOnly {
    override val enforceHTTPS: Option[Boolean] =
      scala.Option(impl.enforceHTTPS()).map(value => value: Boolean)
    override val tlsSecurityPolicy
        : Option[zio.aws.elasticsearch.model.TLSSecurityPolicy] = scala
      .Option(impl.tlsSecurityPolicy())
      .map(value => zio.aws.elasticsearch.model.TLSSecurityPolicy.wrap(value))
    override val customEndpointEnabled: Option[Boolean] =
      scala.Option(impl.customEndpointEnabled()).map(value => value: Boolean)
    override val customEndpoint: Option[DomainNameFqdn] = scala
      .Option(impl.customEndpoint())
      .map(value =>
        zio.aws.elasticsearch.model.primitives.DomainNameFqdn(value)
      )
    override val customEndpointCertificateArn: Option[ARN] = scala
      .Option(impl.customEndpointCertificateArn())
      .map(value => zio.aws.elasticsearch.model.primitives.ARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.DomainEndpointOptions
  ): zio.aws.elasticsearch.model.DomainEndpointOptions.ReadOnly = new Wrapper(
    impl
  )
}
