package zio.aws.elasticsearch.model
import java.lang.Integer
import zio.aws.elasticsearch.model.primitives.{NextToken, MaxResults, GUID}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeReservedElasticsearchInstancesRequest(
    reservedElasticsearchInstanceId: Option[GUID] = None,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstancesRequest = {
    import DescribeReservedElasticsearchInstancesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstancesRequest
      .builder()
      .optionallyWith(
        reservedElasticsearchInstanceId.map(value =>
          GUID.unwrap(value): java.lang.String
        )
      )(_.reservedElasticsearchInstanceId)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.DescribeReservedElasticsearchInstancesRequest.ReadOnly =
    zio.aws.elasticsearch.model.DescribeReservedElasticsearchInstancesRequest
      .wrap(buildAwsValue())
}
object DescribeReservedElasticsearchInstancesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstancesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticsearch.model.DescribeReservedElasticsearchInstancesRequest =
      zio.aws.elasticsearch.model.DescribeReservedElasticsearchInstancesRequest(
        reservedElasticsearchInstanceId.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def reservedElasticsearchInstanceId: Option[GUID]
    def maxResults: Option[MaxResults]
    def nextToken: Option[NextToken]
    def getReservedElasticsearchInstanceId: ZIO[Any, AwsError, GUID] =
      AwsError.unwrapOptionField(
        "reservedElasticsearchInstanceId",
        reservedElasticsearchInstanceId
      )
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstancesRequest
  ) extends zio.aws.elasticsearch.model.DescribeReservedElasticsearchInstancesRequest.ReadOnly {
    override val reservedElasticsearchInstanceId: Option[GUID] = scala
      .Option(impl.reservedElasticsearchInstanceId())
      .map(value => zio.aws.elasticsearch.model.primitives.GUID(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.elasticsearch.model.primitives.MaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.elasticsearch.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstancesRequest
  ): zio.aws.elasticsearch.model.DescribeReservedElasticsearchInstancesRequest.ReadOnly =
    new Wrapper(impl)
}
