package zio.aws.elasticsearch.model
import zio.aws.elasticsearch.model.primitives.{
  ElasticsearchVersionString,
  DomainName,
  DomainId,
  ServiceUrl,
  PolicyDocument,
  ARN
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ElasticsearchDomainStatus(
    domainId: DomainId,
    domainName: DomainName,
    arn: ARN,
    created: Option[Boolean] = None,
    deleted: Option[Boolean] = None,
    endpoint: Option[ServiceUrl] = None,
    endpoints: Option[Map[String, ServiceUrl]] = None,
    processing: Option[Boolean] = None,
    upgradeProcessing: Option[Boolean] = None,
    elasticsearchVersion: Option[ElasticsearchVersionString] = None,
    elasticsearchClusterConfig: zio.aws.elasticsearch.model.ElasticsearchClusterConfig,
    ebsOptions: Option[zio.aws.elasticsearch.model.EBSOptions] = None,
    accessPolicies: Option[PolicyDocument] = None,
    snapshotOptions: Option[zio.aws.elasticsearch.model.SnapshotOptions] = None,
    vpcOptions: Option[zio.aws.elasticsearch.model.VPCDerivedInfo] = None,
    cognitoOptions: Option[zio.aws.elasticsearch.model.CognitoOptions] = None,
    encryptionAtRestOptions: Option[
      zio.aws.elasticsearch.model.EncryptionAtRestOptions
    ] = None,
    nodeToNodeEncryptionOptions: Option[
      zio.aws.elasticsearch.model.NodeToNodeEncryptionOptions
    ] = None,
    advancedOptions: Option[Map[String, String]] = None,
    logPublishingOptions: Option[Map[
      zio.aws.elasticsearch.model.LogType,
      zio.aws.elasticsearch.model.LogPublishingOption
    ]] = None,
    serviceSoftwareOptions: Option[
      zio.aws.elasticsearch.model.ServiceSoftwareOptions
    ] = None,
    domainEndpointOptions: Option[
      zio.aws.elasticsearch.model.DomainEndpointOptions
    ] = None,
    advancedSecurityOptions: Option[
      zio.aws.elasticsearch.model.AdvancedSecurityOptions
    ] = None,
    autoTuneOptions: Option[zio.aws.elasticsearch.model.AutoTuneOptionsOutput] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.ElasticsearchDomainStatus = {
    import ElasticsearchDomainStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.ElasticsearchDomainStatus
      .builder()
      .domainId(DomainId.unwrap(domainId): java.lang.String)
      .domainName(DomainName.unwrap(domainName): java.lang.String)
      .arn(ARN.unwrap(arn): java.lang.String)
      .optionallyWith(created.map(value => value: java.lang.Boolean))(_.created)
      .optionallyWith(deleted.map(value => value: java.lang.Boolean))(_.deleted)
      .optionallyWith(
        endpoint.map(value => ServiceUrl.unwrap(value): java.lang.String)
      )(_.endpoint)
      .optionallyWith(
        endpoints.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (ServiceUrl.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.endpoints)
      .optionallyWith(processing.map(value => value: java.lang.Boolean))(
        _.processing
      )
      .optionallyWith(upgradeProcessing.map(value => value: java.lang.Boolean))(
        _.upgradeProcessing
      )
      .optionallyWith(
        elasticsearchVersion.map(value =>
          ElasticsearchVersionString.unwrap(value): java.lang.String
        )
      )(_.elasticsearchVersion)
      .elasticsearchClusterConfig(elasticsearchClusterConfig.buildAwsValue())
      .optionallyWith(ebsOptions.map(value => value.buildAwsValue()))(
        _.ebsOptions
      )
      .optionallyWith(
        accessPolicies.map(value =>
          PolicyDocument.unwrap(value): java.lang.String
        )
      )(_.accessPolicies)
      .optionallyWith(snapshotOptions.map(value => value.buildAwsValue()))(
        _.snapshotOptions
      )
      .optionallyWith(vpcOptions.map(value => value.buildAwsValue()))(
        _.vpcOptions
      )
      .optionallyWith(cognitoOptions.map(value => value.buildAwsValue()))(
        _.cognitoOptions
      )
      .optionallyWith(
        encryptionAtRestOptions.map(value => value.buildAwsValue())
      )(_.encryptionAtRestOptions)
      .optionallyWith(
        nodeToNodeEncryptionOptions.map(value => value.buildAwsValue())
      )(_.nodeToNodeEncryptionOptions)
      .optionallyWith(
        advancedOptions.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.advancedOptions)
      .optionallyWith(
        logPublishingOptions.map(value =>
          value
            .map({ case (key, value) =>
              key.unwrap.toString -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.logPublishingOptionsWithStrings)
      .optionallyWith(
        serviceSoftwareOptions.map(value => value.buildAwsValue())
      )(_.serviceSoftwareOptions)
      .optionallyWith(
        domainEndpointOptions.map(value => value.buildAwsValue())
      )(_.domainEndpointOptions)
      .optionallyWith(
        advancedSecurityOptions.map(value => value.buildAwsValue())
      )(_.advancedSecurityOptions)
      .optionallyWith(autoTuneOptions.map(value => value.buildAwsValue()))(
        _.autoTuneOptions
      )
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.ElasticsearchDomainStatus.ReadOnly =
    zio.aws.elasticsearch.model.ElasticsearchDomainStatus.wrap(buildAwsValue())
}
object ElasticsearchDomainStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.ElasticsearchDomainStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.ElasticsearchDomainStatus =
      zio.aws.elasticsearch.model.ElasticsearchDomainStatus(
        domainId,
        domainName,
        arn,
        created.map(value => value),
        deleted.map(value => value),
        endpoint.map(value => value),
        endpoints.map(value => value),
        processing.map(value => value),
        upgradeProcessing.map(value => value),
        elasticsearchVersion.map(value => value),
        elasticsearchClusterConfig.asEditable,
        ebsOptions.map(value => value.asEditable),
        accessPolicies.map(value => value),
        snapshotOptions.map(value => value.asEditable),
        vpcOptions.map(value => value.asEditable),
        cognitoOptions.map(value => value.asEditable),
        encryptionAtRestOptions.map(value => value.asEditable),
        nodeToNodeEncryptionOptions.map(value => value.asEditable),
        advancedOptions.map(value => value),
        logPublishingOptions.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        serviceSoftwareOptions.map(value => value.asEditable),
        domainEndpointOptions.map(value => value.asEditable),
        advancedSecurityOptions.map(value => value.asEditable),
        autoTuneOptions.map(value => value.asEditable)
      )
    def domainId: DomainId
    def domainName: DomainName
    def arn: ARN
    def created: Option[Boolean]
    def deleted: Option[Boolean]
    def endpoint: Option[ServiceUrl]
    def endpoints: Option[Map[String, ServiceUrl]]
    def processing: Option[Boolean]
    def upgradeProcessing: Option[Boolean]
    def elasticsearchVersion: Option[ElasticsearchVersionString]
    def elasticsearchClusterConfig
        : zio.aws.elasticsearch.model.ElasticsearchClusterConfig.ReadOnly
    def ebsOptions: Option[zio.aws.elasticsearch.model.EBSOptions.ReadOnly]
    def accessPolicies: Option[PolicyDocument]
    def snapshotOptions
        : Option[zio.aws.elasticsearch.model.SnapshotOptions.ReadOnly]
    def vpcOptions: Option[zio.aws.elasticsearch.model.VPCDerivedInfo.ReadOnly]
    def cognitoOptions
        : Option[zio.aws.elasticsearch.model.CognitoOptions.ReadOnly]
    def encryptionAtRestOptions
        : Option[zio.aws.elasticsearch.model.EncryptionAtRestOptions.ReadOnly]
    def nodeToNodeEncryptionOptions: Option[
      zio.aws.elasticsearch.model.NodeToNodeEncryptionOptions.ReadOnly
    ]
    def advancedOptions: Option[Map[String, String]]
    def logPublishingOptions: Option[Map[
      zio.aws.elasticsearch.model.LogType,
      zio.aws.elasticsearch.model.LogPublishingOption.ReadOnly
    ]]
    def serviceSoftwareOptions
        : Option[zio.aws.elasticsearch.model.ServiceSoftwareOptions.ReadOnly]
    def domainEndpointOptions
        : Option[zio.aws.elasticsearch.model.DomainEndpointOptions.ReadOnly]
    def advancedSecurityOptions
        : Option[zio.aws.elasticsearch.model.AdvancedSecurityOptions.ReadOnly]
    def autoTuneOptions
        : Option[zio.aws.elasticsearch.model.AutoTuneOptionsOutput.ReadOnly]
    def getDomainId: ZIO[Any, Nothing, DomainId] = ZIO.succeed(domainId)
    def getDomainName: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domainName)
    def getArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(arn)
    def getCreated: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("created", created)
    def getDeleted: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("deleted", deleted)
    def getEndpoint: ZIO[Any, AwsError, ServiceUrl] =
      AwsError.unwrapOptionField("endpoint", endpoint)
    def getEndpoints: ZIO[Any, AwsError, Map[String, ServiceUrl]] =
      AwsError.unwrapOptionField("endpoints", endpoints)
    def getProcessing: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("processing", processing)
    def getUpgradeProcessing: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("upgradeProcessing", upgradeProcessing)
    def getElasticsearchVersion
        : ZIO[Any, AwsError, ElasticsearchVersionString] =
      AwsError.unwrapOptionField("elasticsearchVersion", elasticsearchVersion)
    def getElasticsearchClusterConfig: ZIO[
      Any,
      Nothing,
      zio.aws.elasticsearch.model.ElasticsearchClusterConfig.ReadOnly
    ] = ZIO.succeed(elasticsearchClusterConfig)
    def getEbsOptions
        : ZIO[Any, AwsError, zio.aws.elasticsearch.model.EBSOptions.ReadOnly] =
      AwsError.unwrapOptionField("ebsOptions", ebsOptions)
    def getAccessPolicies: ZIO[Any, AwsError, PolicyDocument] =
      AwsError.unwrapOptionField("accessPolicies", accessPolicies)
    def getSnapshotOptions: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.SnapshotOptions.ReadOnly
    ] = AwsError.unwrapOptionField("snapshotOptions", snapshotOptions)
    def getVpcOptions: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.VPCDerivedInfo.ReadOnly
    ] = AwsError.unwrapOptionField("vpcOptions", vpcOptions)
    def getCognitoOptions: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.CognitoOptions.ReadOnly
    ] = AwsError.unwrapOptionField("cognitoOptions", cognitoOptions)
    def getEncryptionAtRestOptions: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.EncryptionAtRestOptions.ReadOnly
    ] = AwsError.unwrapOptionField(
      "encryptionAtRestOptions",
      encryptionAtRestOptions
    )
    def getNodeToNodeEncryptionOptions: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.NodeToNodeEncryptionOptions.ReadOnly
    ] = AwsError.unwrapOptionField(
      "nodeToNodeEncryptionOptions",
      nodeToNodeEncryptionOptions
    )
    def getAdvancedOptions: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("advancedOptions", advancedOptions)
    def getLogPublishingOptions: ZIO[Any, AwsError, Map[
      zio.aws.elasticsearch.model.LogType,
      zio.aws.elasticsearch.model.LogPublishingOption.ReadOnly
    ]] =
      AwsError.unwrapOptionField("logPublishingOptions", logPublishingOptions)
    def getServiceSoftwareOptions: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.ServiceSoftwareOptions.ReadOnly
    ] = AwsError.unwrapOptionField(
      "serviceSoftwareOptions",
      serviceSoftwareOptions
    )
    def getDomainEndpointOptions: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.DomainEndpointOptions.ReadOnly
    ] =
      AwsError.unwrapOptionField("domainEndpointOptions", domainEndpointOptions)
    def getAdvancedSecurityOptions: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.AdvancedSecurityOptions.ReadOnly
    ] = AwsError.unwrapOptionField(
      "advancedSecurityOptions",
      advancedSecurityOptions
    )
    def getAutoTuneOptions: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.AutoTuneOptionsOutput.ReadOnly
    ] = AwsError.unwrapOptionField("autoTuneOptions", autoTuneOptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.ElasticsearchDomainStatus
  ) extends zio.aws.elasticsearch.model.ElasticsearchDomainStatus.ReadOnly {
    override val domainId: DomainId =
      zio.aws.elasticsearch.model.primitives.DomainId(impl.domainId())
    override val domainName: DomainName =
      zio.aws.elasticsearch.model.primitives.DomainName(impl.domainName())
    override val arn: ARN =
      zio.aws.elasticsearch.model.primitives.ARN(impl.arn())
    override val created: Option[Boolean] =
      scala.Option(impl.created()).map(value => value: Boolean)
    override val deleted: Option[Boolean] =
      scala.Option(impl.deleted()).map(value => value: Boolean)
    override val endpoint: Option[ServiceUrl] = scala
      .Option(impl.endpoint())
      .map(value => zio.aws.elasticsearch.model.primitives.ServiceUrl(value))
    override val endpoints: Option[Map[String, ServiceUrl]] = scala
      .Option(impl.endpoints())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> zio.aws.elasticsearch.model.primitives
              .ServiceUrl(value)
          })
          .toMap
      )
    override val processing: Option[Boolean] =
      scala.Option(impl.processing()).map(value => value: Boolean)
    override val upgradeProcessing: Option[Boolean] =
      scala.Option(impl.upgradeProcessing()).map(value => value: Boolean)
    override val elasticsearchVersion: Option[ElasticsearchVersionString] =
      scala
        .Option(impl.elasticsearchVersion())
        .map(value =>
          zio.aws.elasticsearch.model.primitives
            .ElasticsearchVersionString(value)
        )
    override val elasticsearchClusterConfig
        : zio.aws.elasticsearch.model.ElasticsearchClusterConfig.ReadOnly =
      zio.aws.elasticsearch.model.ElasticsearchClusterConfig
        .wrap(impl.elasticsearchClusterConfig())
    override val ebsOptions
        : Option[zio.aws.elasticsearch.model.EBSOptions.ReadOnly] = scala
      .Option(impl.ebsOptions())
      .map(value => zio.aws.elasticsearch.model.EBSOptions.wrap(value))
    override val accessPolicies: Option[PolicyDocument] = scala
      .Option(impl.accessPolicies())
      .map(value =>
        zio.aws.elasticsearch.model.primitives.PolicyDocument(value)
      )
    override val snapshotOptions
        : Option[zio.aws.elasticsearch.model.SnapshotOptions.ReadOnly] = scala
      .Option(impl.snapshotOptions())
      .map(value => zio.aws.elasticsearch.model.SnapshotOptions.wrap(value))
    override val vpcOptions
        : Option[zio.aws.elasticsearch.model.VPCDerivedInfo.ReadOnly] = scala
      .Option(impl.vpcOptions())
      .map(value => zio.aws.elasticsearch.model.VPCDerivedInfo.wrap(value))
    override val cognitoOptions
        : Option[zio.aws.elasticsearch.model.CognitoOptions.ReadOnly] = scala
      .Option(impl.cognitoOptions())
      .map(value => zio.aws.elasticsearch.model.CognitoOptions.wrap(value))
    override val encryptionAtRestOptions
        : Option[zio.aws.elasticsearch.model.EncryptionAtRestOptions.ReadOnly] =
      scala
        .Option(impl.encryptionAtRestOptions())
        .map(value =>
          zio.aws.elasticsearch.model.EncryptionAtRestOptions.wrap(value)
        )
    override val nodeToNodeEncryptionOptions: Option[
      zio.aws.elasticsearch.model.NodeToNodeEncryptionOptions.ReadOnly
    ] = scala
      .Option(impl.nodeToNodeEncryptionOptions())
      .map(value =>
        zio.aws.elasticsearch.model.NodeToNodeEncryptionOptions.wrap(value)
      )
    override val advancedOptions: Option[Map[String, String]] = scala
      .Option(impl.advancedOptions())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val logPublishingOptions: Option[Map[
      zio.aws.elasticsearch.model.LogType,
      zio.aws.elasticsearch.model.LogPublishingOption.ReadOnly
    ]] = scala
      .Option(impl.logPublishingOptions())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.elasticsearch.model.LogType.wrap(
              key
            ) -> zio.aws.elasticsearch.model.LogPublishingOption.wrap(value)
          })
          .toMap
      )
    override val serviceSoftwareOptions
        : Option[zio.aws.elasticsearch.model.ServiceSoftwareOptions.ReadOnly] =
      scala
        .Option(impl.serviceSoftwareOptions())
        .map(value =>
          zio.aws.elasticsearch.model.ServiceSoftwareOptions.wrap(value)
        )
    override val domainEndpointOptions
        : Option[zio.aws.elasticsearch.model.DomainEndpointOptions.ReadOnly] =
      scala
        .Option(impl.domainEndpointOptions())
        .map(value =>
          zio.aws.elasticsearch.model.DomainEndpointOptions.wrap(value)
        )
    override val advancedSecurityOptions
        : Option[zio.aws.elasticsearch.model.AdvancedSecurityOptions.ReadOnly] =
      scala
        .Option(impl.advancedSecurityOptions())
        .map(value =>
          zio.aws.elasticsearch.model.AdvancedSecurityOptions.wrap(value)
        )
    override val autoTuneOptions
        : Option[zio.aws.elasticsearch.model.AutoTuneOptionsOutput.ReadOnly] =
      scala
        .Option(impl.autoTuneOptions())
        .map(value =>
          zio.aws.elasticsearch.model.AutoTuneOptionsOutput.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.ElasticsearchDomainStatus
  ): zio.aws.elasticsearch.model.ElasticsearchDomainStatus.ReadOnly =
    new Wrapper(impl)
}
