package zio.aws.elasticsearch.model
import java.lang.Integer
import zio.aws.elasticsearch.model.primitives.IntegerClass
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ZoneAwarenessConfig(
    availabilityZoneCount: Option[IntegerClass] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.ZoneAwarenessConfig = {
    import ZoneAwarenessConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.ZoneAwarenessConfig
      .builder()
      .optionallyWith(
        availabilityZoneCount.map(value => IntegerClass.unwrap(value): Integer)
      )(_.availabilityZoneCount)
      .build()
  }
  def asReadOnly: zio.aws.elasticsearch.model.ZoneAwarenessConfig.ReadOnly =
    zio.aws.elasticsearch.model.ZoneAwarenessConfig.wrap(buildAwsValue())
}
object ZoneAwarenessConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.ZoneAwarenessConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.ZoneAwarenessConfig =
      zio.aws.elasticsearch.model
        .ZoneAwarenessConfig(availabilityZoneCount.map(value => value))
    def availabilityZoneCount: Option[IntegerClass]
    def getAvailabilityZoneCount: ZIO[Any, AwsError, IntegerClass] =
      AwsError.unwrapOptionField("availabilityZoneCount", availabilityZoneCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.ZoneAwarenessConfig
  ) extends zio.aws.elasticsearch.model.ZoneAwarenessConfig.ReadOnly {
    override val availabilityZoneCount: Option[IntegerClass] = scala
      .Option(impl.availabilityZoneCount())
      .map(value => zio.aws.elasticsearch.model.primitives.IntegerClass(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.ZoneAwarenessConfig
  ): zio.aws.elasticsearch.model.ZoneAwarenessConfig.ReadOnly = new Wrapper(
    impl
  )
}
