package zio.aws.elasticsearch.model
import zio.aws.elasticsearch.model.primitives.{
  ConnectionAlias,
  CrossClusterSearchConnectionId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class OutboundCrossClusterSearchConnection(
    sourceDomainInfo: Option[zio.aws.elasticsearch.model.DomainInformation] =
      None,
    destinationDomainInfo: Option[
      zio.aws.elasticsearch.model.DomainInformation
    ] = None,
    crossClusterSearchConnectionId: Option[CrossClusterSearchConnectionId] =
      None,
    connectionAlias: Option[ConnectionAlias] = None,
    connectionStatus: Option[
      zio.aws.elasticsearch.model.OutboundCrossClusterSearchConnectionStatus
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.OutboundCrossClusterSearchConnection = {
    import OutboundCrossClusterSearchConnection.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.OutboundCrossClusterSearchConnection
      .builder()
      .optionallyWith(sourceDomainInfo.map(value => value.buildAwsValue()))(
        _.sourceDomainInfo
      )
      .optionallyWith(
        destinationDomainInfo.map(value => value.buildAwsValue())
      )(_.destinationDomainInfo)
      .optionallyWith(
        crossClusterSearchConnectionId.map(value =>
          CrossClusterSearchConnectionId.unwrap(value): java.lang.String
        )
      )(_.crossClusterSearchConnectionId)
      .optionallyWith(
        connectionAlias.map(value =>
          ConnectionAlias.unwrap(value): java.lang.String
        )
      )(_.connectionAlias)
      .optionallyWith(connectionStatus.map(value => value.buildAwsValue()))(
        _.connectionStatus
      )
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.OutboundCrossClusterSearchConnection.ReadOnly =
    zio.aws.elasticsearch.model.OutboundCrossClusterSearchConnection
      .wrap(buildAwsValue())
}
object OutboundCrossClusterSearchConnection {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.OutboundCrossClusterSearchConnection
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticsearch.model.OutboundCrossClusterSearchConnection =
      zio.aws.elasticsearch.model.OutboundCrossClusterSearchConnection(
        sourceDomainInfo.map(value => value.asEditable),
        destinationDomainInfo.map(value => value.asEditable),
        crossClusterSearchConnectionId.map(value => value),
        connectionAlias.map(value => value),
        connectionStatus.map(value => value.asEditable)
      )
    def sourceDomainInfo
        : Option[zio.aws.elasticsearch.model.DomainInformation.ReadOnly]
    def destinationDomainInfo
        : Option[zio.aws.elasticsearch.model.DomainInformation.ReadOnly]
    def crossClusterSearchConnectionId: Option[CrossClusterSearchConnectionId]
    def connectionAlias: Option[ConnectionAlias]
    def connectionStatus: Option[
      zio.aws.elasticsearch.model.OutboundCrossClusterSearchConnectionStatus.ReadOnly
    ]
    def getSourceDomainInfo: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.DomainInformation.ReadOnly
    ] = AwsError.unwrapOptionField("sourceDomainInfo", sourceDomainInfo)
    def getDestinationDomainInfo: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.DomainInformation.ReadOnly
    ] =
      AwsError.unwrapOptionField("destinationDomainInfo", destinationDomainInfo)
    def getCrossClusterSearchConnectionId
        : ZIO[Any, AwsError, CrossClusterSearchConnectionId] =
      AwsError.unwrapOptionField(
        "crossClusterSearchConnectionId",
        crossClusterSearchConnectionId
      )
    def getConnectionAlias: ZIO[Any, AwsError, ConnectionAlias] =
      AwsError.unwrapOptionField("connectionAlias", connectionAlias)
    def getConnectionStatus: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.OutboundCrossClusterSearchConnectionStatus.ReadOnly
    ] = AwsError.unwrapOptionField("connectionStatus", connectionStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.OutboundCrossClusterSearchConnection
  ) extends zio.aws.elasticsearch.model.OutboundCrossClusterSearchConnection.ReadOnly {
    override val sourceDomainInfo
        : Option[zio.aws.elasticsearch.model.DomainInformation.ReadOnly] = scala
      .Option(impl.sourceDomainInfo())
      .map(value => zio.aws.elasticsearch.model.DomainInformation.wrap(value))
    override val destinationDomainInfo
        : Option[zio.aws.elasticsearch.model.DomainInformation.ReadOnly] = scala
      .Option(impl.destinationDomainInfo())
      .map(value => zio.aws.elasticsearch.model.DomainInformation.wrap(value))
    override val crossClusterSearchConnectionId
        : Option[CrossClusterSearchConnectionId] = scala
      .Option(impl.crossClusterSearchConnectionId())
      .map(value =>
        zio.aws.elasticsearch.model.primitives
          .CrossClusterSearchConnectionId(value)
      )
    override val connectionAlias: Option[ConnectionAlias] = scala
      .Option(impl.connectionAlias())
      .map(value =>
        zio.aws.elasticsearch.model.primitives.ConnectionAlias(value)
      )
    override val connectionStatus: Option[
      zio.aws.elasticsearch.model.OutboundCrossClusterSearchConnectionStatus.ReadOnly
    ] = scala
      .Option(impl.connectionStatus())
      .map(value =>
        zio.aws.elasticsearch.model.OutboundCrossClusterSearchConnectionStatus
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.OutboundCrossClusterSearchConnection
  ): zio.aws.elasticsearch.model.OutboundCrossClusterSearchConnection.ReadOnly =
    new Wrapper(impl)
}
