package zio.aws.elasticsearch.model
import zio.aws.elasticsearch.model.primitives.{
  ElasticsearchVersionString,
  DomainName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpgradeElasticsearchDomainResponse(
    domainName: Option[DomainName] = None,
    targetVersion: Option[ElasticsearchVersionString] = None,
    performCheckOnly: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.UpgradeElasticsearchDomainResponse = {
    import UpgradeElasticsearchDomainResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.UpgradeElasticsearchDomainResponse
      .builder()
      .optionallyWith(
        domainName.map(value => DomainName.unwrap(value): java.lang.String)
      )(_.domainName)
      .optionallyWith(
        targetVersion.map(value =>
          ElasticsearchVersionString.unwrap(value): java.lang.String
        )
      )(_.targetVersion)
      .optionallyWith(performCheckOnly.map(value => value: java.lang.Boolean))(
        _.performCheckOnly
      )
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.UpgradeElasticsearchDomainResponse.ReadOnly =
    zio.aws.elasticsearch.model.UpgradeElasticsearchDomainResponse
      .wrap(buildAwsValue())
}
object UpgradeElasticsearchDomainResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.UpgradeElasticsearchDomainResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticsearch.model.UpgradeElasticsearchDomainResponse =
      zio.aws.elasticsearch.model.UpgradeElasticsearchDomainResponse(
        domainName.map(value => value),
        targetVersion.map(value => value),
        performCheckOnly.map(value => value)
      )
    def domainName: Option[DomainName]
    def targetVersion: Option[ElasticsearchVersionString]
    def performCheckOnly: Option[Boolean]
    def getDomainName: ZIO[Any, AwsError, DomainName] =
      AwsError.unwrapOptionField("domainName", domainName)
    def getTargetVersion: ZIO[Any, AwsError, ElasticsearchVersionString] =
      AwsError.unwrapOptionField("targetVersion", targetVersion)
    def getPerformCheckOnly: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("performCheckOnly", performCheckOnly)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.UpgradeElasticsearchDomainResponse
  ) extends zio.aws.elasticsearch.model.UpgradeElasticsearchDomainResponse.ReadOnly {
    override val domainName: Option[DomainName] = scala
      .Option(impl.domainName())
      .map(value => zio.aws.elasticsearch.model.primitives.DomainName(value))
    override val targetVersion: Option[ElasticsearchVersionString] = scala
      .Option(impl.targetVersion())
      .map(value =>
        zio.aws.elasticsearch.model.primitives.ElasticsearchVersionString(value)
      )
    override val performCheckOnly: Option[Boolean] =
      scala.Option(impl.performCheckOnly()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.UpgradeElasticsearchDomainResponse
  ): zio.aws.elasticsearch.model.UpgradeElasticsearchDomainResponse.ReadOnly =
    new Wrapper(impl)
}
