package zio.aws.elasticsearch.model
import zio.aws.elasticsearch.model.primitives.{
  DryRun,
  PolicyDocument,
  DomainName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateElasticsearchDomainConfigRequest(
    domainName: DomainName,
    elasticsearchClusterConfig: Option[
      zio.aws.elasticsearch.model.ElasticsearchClusterConfig
    ] = None,
    ebsOptions: Option[zio.aws.elasticsearch.model.EBSOptions] = None,
    snapshotOptions: Option[zio.aws.elasticsearch.model.SnapshotOptions] = None,
    vpcOptions: Option[zio.aws.elasticsearch.model.VPCOptions] = None,
    cognitoOptions: Option[zio.aws.elasticsearch.model.CognitoOptions] = None,
    advancedOptions: Option[Map[String, String]] = None,
    accessPolicies: Option[PolicyDocument] = None,
    logPublishingOptions: Option[Map[
      zio.aws.elasticsearch.model.LogType,
      zio.aws.elasticsearch.model.LogPublishingOption
    ]] = None,
    domainEndpointOptions: Option[
      zio.aws.elasticsearch.model.DomainEndpointOptions
    ] = None,
    advancedSecurityOptions: Option[
      zio.aws.elasticsearch.model.AdvancedSecurityOptionsInput
    ] = None,
    nodeToNodeEncryptionOptions: Option[
      zio.aws.elasticsearch.model.NodeToNodeEncryptionOptions
    ] = None,
    encryptionAtRestOptions: Option[
      zio.aws.elasticsearch.model.EncryptionAtRestOptions
    ] = None,
    autoTuneOptions: Option[zio.aws.elasticsearch.model.AutoTuneOptions] = None,
    dryRun: Option[DryRun] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.UpdateElasticsearchDomainConfigRequest = {
    import UpdateElasticsearchDomainConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.UpdateElasticsearchDomainConfigRequest
      .builder()
      .domainName(DomainName.unwrap(domainName): java.lang.String)
      .optionallyWith(
        elasticsearchClusterConfig.map(value => value.buildAwsValue())
      )(_.elasticsearchClusterConfig)
      .optionallyWith(ebsOptions.map(value => value.buildAwsValue()))(
        _.ebsOptions
      )
      .optionallyWith(snapshotOptions.map(value => value.buildAwsValue()))(
        _.snapshotOptions
      )
      .optionallyWith(vpcOptions.map(value => value.buildAwsValue()))(
        _.vpcOptions
      )
      .optionallyWith(cognitoOptions.map(value => value.buildAwsValue()))(
        _.cognitoOptions
      )
      .optionallyWith(
        advancedOptions.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.advancedOptions)
      .optionallyWith(
        accessPolicies.map(value =>
          PolicyDocument.unwrap(value): java.lang.String
        )
      )(_.accessPolicies)
      .optionallyWith(
        logPublishingOptions.map(value =>
          value
            .map({ case (key, value) =>
              key.unwrap.toString -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.logPublishingOptionsWithStrings)
      .optionallyWith(
        domainEndpointOptions.map(value => value.buildAwsValue())
      )(_.domainEndpointOptions)
      .optionallyWith(
        advancedSecurityOptions.map(value => value.buildAwsValue())
      )(_.advancedSecurityOptions)
      .optionallyWith(
        nodeToNodeEncryptionOptions.map(value => value.buildAwsValue())
      )(_.nodeToNodeEncryptionOptions)
      .optionallyWith(
        encryptionAtRestOptions.map(value => value.buildAwsValue())
      )(_.encryptionAtRestOptions)
      .optionallyWith(autoTuneOptions.map(value => value.buildAwsValue()))(
        _.autoTuneOptions
      )
      .optionallyWith(
        dryRun.map(value => DryRun.unwrap(value): java.lang.Boolean)
      )(_.dryRun)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.UpdateElasticsearchDomainConfigRequest.ReadOnly =
    zio.aws.elasticsearch.model.UpdateElasticsearchDomainConfigRequest
      .wrap(buildAwsValue())
}
object UpdateElasticsearchDomainConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.UpdateElasticsearchDomainConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticsearch.model.UpdateElasticsearchDomainConfigRequest =
      zio.aws.elasticsearch.model.UpdateElasticsearchDomainConfigRequest(
        domainName,
        elasticsearchClusterConfig.map(value => value.asEditable),
        ebsOptions.map(value => value.asEditable),
        snapshotOptions.map(value => value.asEditable),
        vpcOptions.map(value => value.asEditable),
        cognitoOptions.map(value => value.asEditable),
        advancedOptions.map(value => value),
        accessPolicies.map(value => value),
        logPublishingOptions.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        domainEndpointOptions.map(value => value.asEditable),
        advancedSecurityOptions.map(value => value.asEditable),
        nodeToNodeEncryptionOptions.map(value => value.asEditable),
        encryptionAtRestOptions.map(value => value.asEditable),
        autoTuneOptions.map(value => value.asEditable),
        dryRun.map(value => value)
      )
    def domainName: DomainName
    def elasticsearchClusterConfig: Option[
      zio.aws.elasticsearch.model.ElasticsearchClusterConfig.ReadOnly
    ]
    def ebsOptions: Option[zio.aws.elasticsearch.model.EBSOptions.ReadOnly]
    def snapshotOptions
        : Option[zio.aws.elasticsearch.model.SnapshotOptions.ReadOnly]
    def vpcOptions: Option[zio.aws.elasticsearch.model.VPCOptions.ReadOnly]
    def cognitoOptions
        : Option[zio.aws.elasticsearch.model.CognitoOptions.ReadOnly]
    def advancedOptions: Option[Map[String, String]]
    def accessPolicies: Option[PolicyDocument]
    def logPublishingOptions: Option[Map[
      zio.aws.elasticsearch.model.LogType,
      zio.aws.elasticsearch.model.LogPublishingOption.ReadOnly
    ]]
    def domainEndpointOptions
        : Option[zio.aws.elasticsearch.model.DomainEndpointOptions.ReadOnly]
    def advancedSecurityOptions: Option[
      zio.aws.elasticsearch.model.AdvancedSecurityOptionsInput.ReadOnly
    ]
    def nodeToNodeEncryptionOptions: Option[
      zio.aws.elasticsearch.model.NodeToNodeEncryptionOptions.ReadOnly
    ]
    def encryptionAtRestOptions
        : Option[zio.aws.elasticsearch.model.EncryptionAtRestOptions.ReadOnly]
    def autoTuneOptions
        : Option[zio.aws.elasticsearch.model.AutoTuneOptions.ReadOnly]
    def dryRun: Option[DryRun]
    def getDomainName: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domainName)
    def getElasticsearchClusterConfig: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.ElasticsearchClusterConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "elasticsearchClusterConfig",
      elasticsearchClusterConfig
    )
    def getEbsOptions
        : ZIO[Any, AwsError, zio.aws.elasticsearch.model.EBSOptions.ReadOnly] =
      AwsError.unwrapOptionField("ebsOptions", ebsOptions)
    def getSnapshotOptions: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.SnapshotOptions.ReadOnly
    ] = AwsError.unwrapOptionField("snapshotOptions", snapshotOptions)
    def getVpcOptions
        : ZIO[Any, AwsError, zio.aws.elasticsearch.model.VPCOptions.ReadOnly] =
      AwsError.unwrapOptionField("vpcOptions", vpcOptions)
    def getCognitoOptions: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.CognitoOptions.ReadOnly
    ] = AwsError.unwrapOptionField("cognitoOptions", cognitoOptions)
    def getAdvancedOptions: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("advancedOptions", advancedOptions)
    def getAccessPolicies: ZIO[Any, AwsError, PolicyDocument] =
      AwsError.unwrapOptionField("accessPolicies", accessPolicies)
    def getLogPublishingOptions: ZIO[Any, AwsError, Map[
      zio.aws.elasticsearch.model.LogType,
      zio.aws.elasticsearch.model.LogPublishingOption.ReadOnly
    ]] =
      AwsError.unwrapOptionField("logPublishingOptions", logPublishingOptions)
    def getDomainEndpointOptions: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.DomainEndpointOptions.ReadOnly
    ] =
      AwsError.unwrapOptionField("domainEndpointOptions", domainEndpointOptions)
    def getAdvancedSecurityOptions: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.AdvancedSecurityOptionsInput.ReadOnly
    ] = AwsError.unwrapOptionField(
      "advancedSecurityOptions",
      advancedSecurityOptions
    )
    def getNodeToNodeEncryptionOptions: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.NodeToNodeEncryptionOptions.ReadOnly
    ] = AwsError.unwrapOptionField(
      "nodeToNodeEncryptionOptions",
      nodeToNodeEncryptionOptions
    )
    def getEncryptionAtRestOptions: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.EncryptionAtRestOptions.ReadOnly
    ] = AwsError.unwrapOptionField(
      "encryptionAtRestOptions",
      encryptionAtRestOptions
    )
    def getAutoTuneOptions: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.AutoTuneOptions.ReadOnly
    ] = AwsError.unwrapOptionField("autoTuneOptions", autoTuneOptions)
    def getDryRun: ZIO[Any, AwsError, DryRun] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.UpdateElasticsearchDomainConfigRequest
  ) extends zio.aws.elasticsearch.model.UpdateElasticsearchDomainConfigRequest.ReadOnly {
    override val domainName: DomainName =
      zio.aws.elasticsearch.model.primitives.DomainName(impl.domainName())
    override val elasticsearchClusterConfig: Option[
      zio.aws.elasticsearch.model.ElasticsearchClusterConfig.ReadOnly
    ] = scala
      .Option(impl.elasticsearchClusterConfig())
      .map(value =>
        zio.aws.elasticsearch.model.ElasticsearchClusterConfig.wrap(value)
      )
    override val ebsOptions
        : Option[zio.aws.elasticsearch.model.EBSOptions.ReadOnly] = scala
      .Option(impl.ebsOptions())
      .map(value => zio.aws.elasticsearch.model.EBSOptions.wrap(value))
    override val snapshotOptions
        : Option[zio.aws.elasticsearch.model.SnapshotOptions.ReadOnly] = scala
      .Option(impl.snapshotOptions())
      .map(value => zio.aws.elasticsearch.model.SnapshotOptions.wrap(value))
    override val vpcOptions
        : Option[zio.aws.elasticsearch.model.VPCOptions.ReadOnly] = scala
      .Option(impl.vpcOptions())
      .map(value => zio.aws.elasticsearch.model.VPCOptions.wrap(value))
    override val cognitoOptions
        : Option[zio.aws.elasticsearch.model.CognitoOptions.ReadOnly] = scala
      .Option(impl.cognitoOptions())
      .map(value => zio.aws.elasticsearch.model.CognitoOptions.wrap(value))
    override val advancedOptions: Option[Map[String, String]] = scala
      .Option(impl.advancedOptions())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val accessPolicies: Option[PolicyDocument] = scala
      .Option(impl.accessPolicies())
      .map(value =>
        zio.aws.elasticsearch.model.primitives.PolicyDocument(value)
      )
    override val logPublishingOptions: Option[Map[
      zio.aws.elasticsearch.model.LogType,
      zio.aws.elasticsearch.model.LogPublishingOption.ReadOnly
    ]] = scala
      .Option(impl.logPublishingOptions())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.elasticsearch.model.LogType.wrap(
              key
            ) -> zio.aws.elasticsearch.model.LogPublishingOption.wrap(value)
          })
          .toMap
      )
    override val domainEndpointOptions
        : Option[zio.aws.elasticsearch.model.DomainEndpointOptions.ReadOnly] =
      scala
        .Option(impl.domainEndpointOptions())
        .map(value =>
          zio.aws.elasticsearch.model.DomainEndpointOptions.wrap(value)
        )
    override val advancedSecurityOptions: Option[
      zio.aws.elasticsearch.model.AdvancedSecurityOptionsInput.ReadOnly
    ] = scala
      .Option(impl.advancedSecurityOptions())
      .map(value =>
        zio.aws.elasticsearch.model.AdvancedSecurityOptionsInput.wrap(value)
      )
    override val nodeToNodeEncryptionOptions: Option[
      zio.aws.elasticsearch.model.NodeToNodeEncryptionOptions.ReadOnly
    ] = scala
      .Option(impl.nodeToNodeEncryptionOptions())
      .map(value =>
        zio.aws.elasticsearch.model.NodeToNodeEncryptionOptions.wrap(value)
      )
    override val encryptionAtRestOptions
        : Option[zio.aws.elasticsearch.model.EncryptionAtRestOptions.ReadOnly] =
      scala
        .Option(impl.encryptionAtRestOptions())
        .map(value =>
          zio.aws.elasticsearch.model.EncryptionAtRestOptions.wrap(value)
        )
    override val autoTuneOptions
        : Option[zio.aws.elasticsearch.model.AutoTuneOptions.ReadOnly] = scala
      .Option(impl.autoTuneOptions())
      .map(value => zio.aws.elasticsearch.model.AutoTuneOptions.wrap(value))
    override val dryRun: Option[DryRun] = scala
      .Option(impl.dryRun())
      .map(value => zio.aws.elasticsearch.model.primitives.DryRun(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.UpdateElasticsearchDomainConfigRequest
  ): zio.aws.elasticsearch.model.UpdateElasticsearchDomainConfigRequest.ReadOnly =
    new Wrapper(impl)
}
