package zio.aws.elasticsearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CancelElasticsearchServiceSoftwareUpdateResponse(
    serviceSoftwareOptions: Option[
      zio.aws.elasticsearch.model.ServiceSoftwareOptions
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.CancelElasticsearchServiceSoftwareUpdateResponse = {
    import CancelElasticsearchServiceSoftwareUpdateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.CancelElasticsearchServiceSoftwareUpdateResponse
      .builder()
      .optionallyWith(
        serviceSoftwareOptions.map(value => value.buildAwsValue())
      )(_.serviceSoftwareOptions)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.CancelElasticsearchServiceSoftwareUpdateResponse.ReadOnly =
    zio.aws.elasticsearch.model.CancelElasticsearchServiceSoftwareUpdateResponse
      .wrap(buildAwsValue())
}
object CancelElasticsearchServiceSoftwareUpdateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.CancelElasticsearchServiceSoftwareUpdateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticsearch.model.CancelElasticsearchServiceSoftwareUpdateResponse =
      zio.aws.elasticsearch.model
        .CancelElasticsearchServiceSoftwareUpdateResponse(
          serviceSoftwareOptions.map(value => value.asEditable)
        )
    def serviceSoftwareOptions
        : Option[zio.aws.elasticsearch.model.ServiceSoftwareOptions.ReadOnly]
    def getServiceSoftwareOptions: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.ServiceSoftwareOptions.ReadOnly
    ] = AwsError.unwrapOptionField(
      "serviceSoftwareOptions",
      serviceSoftwareOptions
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.CancelElasticsearchServiceSoftwareUpdateResponse
  ) extends zio.aws.elasticsearch.model.CancelElasticsearchServiceSoftwareUpdateResponse.ReadOnly {
    override val serviceSoftwareOptions
        : Option[zio.aws.elasticsearch.model.ServiceSoftwareOptions.ReadOnly] =
      scala
        .Option(impl.serviceSoftwareOptions())
        .map(value =>
          zio.aws.elasticsearch.model.ServiceSoftwareOptions.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.CancelElasticsearchServiceSoftwareUpdateResponse
  ): zio.aws.elasticsearch.model.CancelElasticsearchServiceSoftwareUpdateResponse.ReadOnly =
    new Wrapper(impl)
}
