package zio.aws.elasticsearch.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateVpcEndpointResponse(
    vpcEndpoint: zio.aws.elasticsearch.model.VpcEndpoint
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.CreateVpcEndpointResponse = {
    import CreateVpcEndpointResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.CreateVpcEndpointResponse
      .builder()
      .vpcEndpoint(vpcEndpoint.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.CreateVpcEndpointResponse.ReadOnly =
    zio.aws.elasticsearch.model.CreateVpcEndpointResponse.wrap(buildAwsValue())
}
object CreateVpcEndpointResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.CreateVpcEndpointResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.CreateVpcEndpointResponse =
      zio.aws.elasticsearch.model
        .CreateVpcEndpointResponse(vpcEndpoint.asEditable)
    def vpcEndpoint: zio.aws.elasticsearch.model.VpcEndpoint.ReadOnly
    def getVpcEndpoint
        : ZIO[Any, Nothing, zio.aws.elasticsearch.model.VpcEndpoint.ReadOnly] =
      ZIO.succeed(vpcEndpoint)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.CreateVpcEndpointResponse
  ) extends zio.aws.elasticsearch.model.CreateVpcEndpointResponse.ReadOnly {
    override val vpcEndpoint: zio.aws.elasticsearch.model.VpcEndpoint.ReadOnly =
      zio.aws.elasticsearch.model.VpcEndpoint.wrap(impl.vpcEndpoint())
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.CreateVpcEndpointResponse
  ): zio.aws.elasticsearch.model.CreateVpcEndpointResponse.ReadOnly =
    new Wrapper(impl)
}
