package zio.aws.elasticsearch.model
import zio.aws.elasticsearch.model.primitives.VpcEndpointId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteVpcEndpointRequest(vpcEndpointId: VpcEndpointId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.DeleteVpcEndpointRequest = {
    import DeleteVpcEndpointRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.DeleteVpcEndpointRequest
      .builder()
      .vpcEndpointId(VpcEndpointId.unwrap(vpcEndpointId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.DeleteVpcEndpointRequest.ReadOnly =
    zio.aws.elasticsearch.model.DeleteVpcEndpointRequest.wrap(buildAwsValue())
}
object DeleteVpcEndpointRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.DeleteVpcEndpointRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.DeleteVpcEndpointRequest =
      zio.aws.elasticsearch.model.DeleteVpcEndpointRequest(vpcEndpointId)
    def vpcEndpointId: VpcEndpointId
    def getVpcEndpointId: ZIO[Any, Nothing, VpcEndpointId] =
      ZIO.succeed(vpcEndpointId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.DeleteVpcEndpointRequest
  ) extends zio.aws.elasticsearch.model.DeleteVpcEndpointRequest.ReadOnly {
    override val vpcEndpointId: VpcEndpointId =
      zio.aws.elasticsearch.model.primitives.VpcEndpointId(impl.vpcEndpointId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.DeleteVpcEndpointRequest
  ): zio.aws.elasticsearch.model.DeleteVpcEndpointRequest.ReadOnly =
    new Wrapper(impl)
}
