package zio.aws.elasticsearch.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.elasticsearch.model.primitives.{NextToken, MaxResults, GUID}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeReservedElasticsearchInstanceOfferingsRequest(
    reservedElasticsearchInstanceOfferingId: Optional[GUID] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstanceOfferingsRequest = {
    import DescribeReservedElasticsearchInstanceOfferingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstanceOfferingsRequest
      .builder()
      .optionallyWith(
        reservedElasticsearchInstanceOfferingId.map(value =>
          GUID.unwrap(value): java.lang.String
        )
      )(_.reservedElasticsearchInstanceOfferingId)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.DescribeReservedElasticsearchInstanceOfferingsRequest.ReadOnly =
    zio.aws.elasticsearch.model.DescribeReservedElasticsearchInstanceOfferingsRequest
      .wrap(buildAwsValue())
}
object DescribeReservedElasticsearchInstanceOfferingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstanceOfferingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticsearch.model.DescribeReservedElasticsearchInstanceOfferingsRequest =
      zio.aws.elasticsearch.model
        .DescribeReservedElasticsearchInstanceOfferingsRequest(
          reservedElasticsearchInstanceOfferingId.map(value => value),
          maxResults.map(value => value),
          nextToken.map(value => value)
        )
    def reservedElasticsearchInstanceOfferingId: Optional[GUID]
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def getReservedElasticsearchInstanceOfferingId: ZIO[Any, AwsError, GUID] =
      AwsError.unwrapOptionField(
        "reservedElasticsearchInstanceOfferingId",
        reservedElasticsearchInstanceOfferingId
      )
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstanceOfferingsRequest
  ) extends zio.aws.elasticsearch.model.DescribeReservedElasticsearchInstanceOfferingsRequest.ReadOnly {
    override val reservedElasticsearchInstanceOfferingId: Optional[GUID] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reservedElasticsearchInstanceOfferingId())
        .map(value => zio.aws.elasticsearch.model.primitives.GUID(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.elasticsearch.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.elasticsearch.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstanceOfferingsRequest
  ): zio.aws.elasticsearch.model.DescribeReservedElasticsearchInstanceOfferingsRequest.ReadOnly =
    new Wrapper(impl)
}
