package zio.aws.elasticsearch.model
import zio.aws.elasticsearch.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ListVpcEndpointAccessResponse(
    authorizedPrincipalList: Iterable[
      zio.aws.elasticsearch.model.AuthorizedPrincipal
    ],
    nextToken: NextToken
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.ListVpcEndpointAccessResponse = {
    import ListVpcEndpointAccessResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.ListVpcEndpointAccessResponse
      .builder()
      .authorizedPrincipalList(authorizedPrincipalList.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .nextToken(NextToken.unwrap(nextToken): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.ListVpcEndpointAccessResponse.ReadOnly =
    zio.aws.elasticsearch.model.ListVpcEndpointAccessResponse
      .wrap(buildAwsValue())
}
object ListVpcEndpointAccessResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.ListVpcEndpointAccessResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.ListVpcEndpointAccessResponse =
      zio.aws.elasticsearch.model.ListVpcEndpointAccessResponse(
        authorizedPrincipalList.map { item =>
          item.asEditable
        },
        nextToken
      )
    def authorizedPrincipalList
        : List[zio.aws.elasticsearch.model.AuthorizedPrincipal.ReadOnly]
    def nextToken: NextToken
    def getAuthorizedPrincipalList: ZIO[Any, Nothing, List[
      zio.aws.elasticsearch.model.AuthorizedPrincipal.ReadOnly
    ]] = ZIO.succeed(authorizedPrincipalList)
    def getNextToken: ZIO[Any, Nothing, NextToken] = ZIO.succeed(nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.ListVpcEndpointAccessResponse
  ) extends zio.aws.elasticsearch.model.ListVpcEndpointAccessResponse.ReadOnly {
    override val authorizedPrincipalList
        : List[zio.aws.elasticsearch.model.AuthorizedPrincipal.ReadOnly] = impl
      .authorizedPrincipalList()
      .asScala
      .map { item =>
        zio.aws.elasticsearch.model.AuthorizedPrincipal.wrap(item)
      }
      .toList
    override val nextToken: NextToken =
      zio.aws.elasticsearch.model.primitives.NextToken(impl.nextToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.ListVpcEndpointAccessResponse
  ): zio.aws.elasticsearch.model.ListVpcEndpointAccessResponse.ReadOnly =
    new Wrapper(impl)
}
