package zio.aws.elasticsearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AssociatePackageResponse(
    domainPackageDetails: Optional[
      zio.aws.elasticsearch.model.DomainPackageDetails
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.AssociatePackageResponse = {
    import AssociatePackageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.AssociatePackageResponse
      .builder()
      .optionallyWith(domainPackageDetails.map(value => value.buildAwsValue()))(
        _.domainPackageDetails
      )
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.AssociatePackageResponse.ReadOnly =
    zio.aws.elasticsearch.model.AssociatePackageResponse.wrap(buildAwsValue())
}
object AssociatePackageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.AssociatePackageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.AssociatePackageResponse =
      zio.aws.elasticsearch.model.AssociatePackageResponse(
        domainPackageDetails.map(value => value.asEditable)
      )
    def domainPackageDetails
        : Optional[zio.aws.elasticsearch.model.DomainPackageDetails.ReadOnly]
    def getDomainPackageDetails: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.DomainPackageDetails.ReadOnly
    ] = AwsError.unwrapOptionField("domainPackageDetails", domainPackageDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.AssociatePackageResponse
  ) extends zio.aws.elasticsearch.model.AssociatePackageResponse.ReadOnly {
    override val domainPackageDetails
        : Optional[zio.aws.elasticsearch.model.DomainPackageDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.domainPackageDetails())
        .map(value =>
          zio.aws.elasticsearch.model.DomainPackageDetails.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.AssociatePackageResponse
  ): zio.aws.elasticsearch.model.AssociatePackageResponse.ReadOnly =
    new Wrapper(impl)
}
