package zio.aws.elasticsearch.model
import zio.aws.elasticsearch.model.primitives.{AWSAccount, DomainName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class RevokeVpcEndpointAccessRequest(
    domainName: DomainName,
    account: AWSAccount
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.RevokeVpcEndpointAccessRequest = {
    import RevokeVpcEndpointAccessRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.RevokeVpcEndpointAccessRequest
      .builder()
      .domainName(DomainName.unwrap(domainName): java.lang.String)
      .account(AWSAccount.unwrap(account): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.RevokeVpcEndpointAccessRequest.ReadOnly =
    zio.aws.elasticsearch.model.RevokeVpcEndpointAccessRequest
      .wrap(buildAwsValue())
}
object RevokeVpcEndpointAccessRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.RevokeVpcEndpointAccessRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.RevokeVpcEndpointAccessRequest =
      zio.aws.elasticsearch.model
        .RevokeVpcEndpointAccessRequest(domainName, account)
    def domainName: DomainName
    def account: AWSAccount
    def getDomainName: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domainName)
    def getAccount: ZIO[Any, Nothing, AWSAccount] = ZIO.succeed(account)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.RevokeVpcEndpointAccessRequest
  ) extends zio.aws.elasticsearch.model.RevokeVpcEndpointAccessRequest.ReadOnly {
    override val domainName: DomainName =
      zio.aws.elasticsearch.model.primitives.DomainName(impl.domainName())
    override val account: AWSAccount =
      zio.aws.elasticsearch.model.primitives.AWSAccount(impl.account())
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.RevokeVpcEndpointAccessRequest
  ): zio.aws.elasticsearch.model.RevokeVpcEndpointAccessRequest.ReadOnly =
    new Wrapper(impl)
}
