package zio.aws.elasticsearch.model
import scala.jdk.CollectionConverters._
sealed trait AutoTuneType {
  def unwrap: software.amazon.awssdk.services.elasticsearch.model.AutoTuneType
}
object AutoTuneType {
  def wrap(
      value: software.amazon.awssdk.services.elasticsearch.model.AutoTuneType
  ): zio.aws.elasticsearch.model.AutoTuneType = value match {
    case software.amazon.awssdk.services.elasticsearch.model.AutoTuneType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.elasticsearch.model.AutoTuneType.SCHEDULED_ACTION =>
      val r = SCHEDULED_ACTION
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.elasticsearch.model.AutoTuneType {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.AutoTuneType =
      software.amazon.awssdk.services.elasticsearch.model.AutoTuneType.UNKNOWN_TO_SDK_VERSION
  }
  case object SCHEDULED_ACTION
      extends zio.aws.elasticsearch.model.AutoTuneType {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.AutoTuneType =
      software.amazon.awssdk.services.elasticsearch.model.AutoTuneType.SCHEDULED_ACTION
  }
}
