package zio.aws.elasticsearch.model
import zio.aws.elasticsearch.model.primitives.ARN
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AddTagsRequest(
    arn: ARN,
    tagList: Iterable[zio.aws.elasticsearch.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.AddTagsRequest = {
    import AddTagsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.AddTagsRequest
      .builder()
      .arn(ARN.unwrap(arn): java.lang.String)
      .tagList(tagList.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.elasticsearch.model.AddTagsRequest.ReadOnly =
    zio.aws.elasticsearch.model.AddTagsRequest.wrap(buildAwsValue())
}
object AddTagsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.AddTagsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.AddTagsRequest =
      zio.aws.elasticsearch.model.AddTagsRequest(
        arn,
        tagList.map { item =>
          item.asEditable
        }
      )
    def arn: ARN
    def tagList: List[zio.aws.elasticsearch.model.Tag.ReadOnly]
    def getArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(arn)
    def getTagList
        : ZIO[Any, Nothing, List[zio.aws.elasticsearch.model.Tag.ReadOnly]] =
      ZIO.succeed(tagList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.AddTagsRequest
  ) extends zio.aws.elasticsearch.model.AddTagsRequest.ReadOnly {
    override val arn: ARN =
      zio.aws.elasticsearch.model.primitives.ARN(impl.arn())
    override val tagList: List[zio.aws.elasticsearch.model.Tag.ReadOnly] = impl
      .tagList()
      .asScala
      .map { item =>
        zio.aws.elasticsearch.model.Tag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.AddTagsRequest
  ): zio.aws.elasticsearch.model.AddTagsRequest.ReadOnly = new Wrapper(impl)
}
