package zio.aws.elasticsearch.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.elasticsearch.model.primitives.IntegerClass
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ElasticsearchClusterConfig(
    instanceType: Optional[
      zio.aws.elasticsearch.model.ESPartitionInstanceType
    ] = Optional.Absent,
    instanceCount: Optional[IntegerClass] = Optional.Absent,
    dedicatedMasterEnabled: Optional[Boolean] = Optional.Absent,
    zoneAwarenessEnabled: Optional[Boolean] = Optional.Absent,
    zoneAwarenessConfig: Optional[
      zio.aws.elasticsearch.model.ZoneAwarenessConfig
    ] = Optional.Absent,
    dedicatedMasterType: Optional[
      zio.aws.elasticsearch.model.ESPartitionInstanceType
    ] = Optional.Absent,
    dedicatedMasterCount: Optional[IntegerClass] = Optional.Absent,
    warmEnabled: Optional[Boolean] = Optional.Absent,
    warmType: Optional[
      zio.aws.elasticsearch.model.ESWarmPartitionInstanceType
    ] = Optional.Absent,
    warmCount: Optional[IntegerClass] = Optional.Absent,
    coldStorageOptions: Optional[
      zio.aws.elasticsearch.model.ColdStorageOptions
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.ElasticsearchClusterConfig = {
    import ElasticsearchClusterConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.ElasticsearchClusterConfig
      .builder()
      .optionallyWith(instanceType.map(value => value.unwrap))(_.instanceType)
      .optionallyWith(
        instanceCount.map(value => IntegerClass.unwrap(value): Integer)
      )(_.instanceCount)
      .optionallyWith(
        dedicatedMasterEnabled.map(value => value: java.lang.Boolean)
      )(_.dedicatedMasterEnabled)
      .optionallyWith(
        zoneAwarenessEnabled.map(value => value: java.lang.Boolean)
      )(_.zoneAwarenessEnabled)
      .optionallyWith(zoneAwarenessConfig.map(value => value.buildAwsValue()))(
        _.zoneAwarenessConfig
      )
      .optionallyWith(dedicatedMasterType.map(value => value.unwrap))(
        _.dedicatedMasterType
      )
      .optionallyWith(
        dedicatedMasterCount.map(value => IntegerClass.unwrap(value): Integer)
      )(_.dedicatedMasterCount)
      .optionallyWith(warmEnabled.map(value => value: java.lang.Boolean))(
        _.warmEnabled
      )
      .optionallyWith(warmType.map(value => value.unwrap))(_.warmType)
      .optionallyWith(
        warmCount.map(value => IntegerClass.unwrap(value): Integer)
      )(_.warmCount)
      .optionallyWith(coldStorageOptions.map(value => value.buildAwsValue()))(
        _.coldStorageOptions
      )
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.ElasticsearchClusterConfig.ReadOnly =
    zio.aws.elasticsearch.model.ElasticsearchClusterConfig.wrap(buildAwsValue())
}
object ElasticsearchClusterConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.ElasticsearchClusterConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.ElasticsearchClusterConfig =
      zio.aws.elasticsearch.model.ElasticsearchClusterConfig(
        instanceType.map(value => value),
        instanceCount.map(value => value),
        dedicatedMasterEnabled.map(value => value),
        zoneAwarenessEnabled.map(value => value),
        zoneAwarenessConfig.map(value => value.asEditable),
        dedicatedMasterType.map(value => value),
        dedicatedMasterCount.map(value => value),
        warmEnabled.map(value => value),
        warmType.map(value => value),
        warmCount.map(value => value),
        coldStorageOptions.map(value => value.asEditable)
      )
    def instanceType
        : Optional[zio.aws.elasticsearch.model.ESPartitionInstanceType]
    def instanceCount: Optional[IntegerClass]
    def dedicatedMasterEnabled: Optional[Boolean]
    def zoneAwarenessEnabled: Optional[Boolean]
    def zoneAwarenessConfig
        : Optional[zio.aws.elasticsearch.model.ZoneAwarenessConfig.ReadOnly]
    def dedicatedMasterType
        : Optional[zio.aws.elasticsearch.model.ESPartitionInstanceType]
    def dedicatedMasterCount: Optional[IntegerClass]
    def warmEnabled: Optional[Boolean]
    def warmType
        : Optional[zio.aws.elasticsearch.model.ESWarmPartitionInstanceType]
    def warmCount: Optional[IntegerClass]
    def coldStorageOptions
        : Optional[zio.aws.elasticsearch.model.ColdStorageOptions.ReadOnly]
    def getInstanceType: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.ESPartitionInstanceType
    ] = AwsError.unwrapOptionField("instanceType", instanceType)
    def getInstanceCount: ZIO[Any, AwsError, IntegerClass] =
      AwsError.unwrapOptionField("instanceCount", instanceCount)
    def getDedicatedMasterEnabled: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("dedicatedMasterEnabled", dedicatedMasterEnabled)
    def getZoneAwarenessEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("zoneAwarenessEnabled", zoneAwarenessEnabled)
    def getZoneAwarenessConfig: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.ZoneAwarenessConfig.ReadOnly
    ] = AwsError.unwrapOptionField("zoneAwarenessConfig", zoneAwarenessConfig)
    def getDedicatedMasterType: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.ESPartitionInstanceType
    ] = AwsError.unwrapOptionField("dedicatedMasterType", dedicatedMasterType)
    def getDedicatedMasterCount: ZIO[Any, AwsError, IntegerClass] =
      AwsError.unwrapOptionField("dedicatedMasterCount", dedicatedMasterCount)
    def getWarmEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("warmEnabled", warmEnabled)
    def getWarmType: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.ESWarmPartitionInstanceType
    ] = AwsError.unwrapOptionField("warmType", warmType)
    def getWarmCount: ZIO[Any, AwsError, IntegerClass] =
      AwsError.unwrapOptionField("warmCount", warmCount)
    def getColdStorageOptions: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.ColdStorageOptions.ReadOnly
    ] = AwsError.unwrapOptionField("coldStorageOptions", coldStorageOptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.ElasticsearchClusterConfig
  ) extends zio.aws.elasticsearch.model.ElasticsearchClusterConfig.ReadOnly {
    override val instanceType
        : Optional[zio.aws.elasticsearch.model.ESPartitionInstanceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceType())
        .map(value =>
          zio.aws.elasticsearch.model.ESPartitionInstanceType.wrap(value)
        )
    override val instanceCount: Optional[IntegerClass] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceCount())
      .map(value => zio.aws.elasticsearch.model.primitives.IntegerClass(value))
    override val dedicatedMasterEnabled: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dedicatedMasterEnabled())
        .map(value => value: Boolean)
    override val zoneAwarenessEnabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.zoneAwarenessEnabled())
      .map(value => value: Boolean)
    override val zoneAwarenessConfig
        : Optional[zio.aws.elasticsearch.model.ZoneAwarenessConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.zoneAwarenessConfig())
        .map(value =>
          zio.aws.elasticsearch.model.ZoneAwarenessConfig.wrap(value)
        )
    override val dedicatedMasterType
        : Optional[zio.aws.elasticsearch.model.ESPartitionInstanceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dedicatedMasterType())
        .map(value =>
          zio.aws.elasticsearch.model.ESPartitionInstanceType.wrap(value)
        )
    override val dedicatedMasterCount: Optional[IntegerClass] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dedicatedMasterCount())
        .map(value =>
          zio.aws.elasticsearch.model.primitives.IntegerClass(value)
        )
    override val warmEnabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.warmEnabled())
      .map(value => value: Boolean)
    override val warmType
        : Optional[zio.aws.elasticsearch.model.ESWarmPartitionInstanceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.warmType())
        .map(value =>
          zio.aws.elasticsearch.model.ESWarmPartitionInstanceType.wrap(value)
        )
    override val warmCount: Optional[IntegerClass] = zio.aws.core.internal
      .optionalFromNullable(impl.warmCount())
      .map(value => zio.aws.elasticsearch.model.primitives.IntegerClass(value))
    override val coldStorageOptions
        : Optional[zio.aws.elasticsearch.model.ColdStorageOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.coldStorageOptions())
        .map(value =>
          zio.aws.elasticsearch.model.ColdStorageOptions.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.ElasticsearchClusterConfig
  ): zio.aws.elasticsearch.model.ElasticsearchClusterConfig.ReadOnly =
    new Wrapper(impl)
}
