package zio.aws.elasticsearch.model
import zio.aws.elasticsearch.model.primitives.{ClientToken, DomainArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateVpcEndpointRequest(
    domainArn: DomainArn,
    vpcOptions: zio.aws.elasticsearch.model.VPCOptions,
    clientToken: Optional[ClientToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.CreateVpcEndpointRequest = {
    import CreateVpcEndpointRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.CreateVpcEndpointRequest
      .builder()
      .domainArn(DomainArn.unwrap(domainArn): java.lang.String)
      .vpcOptions(vpcOptions.buildAwsValue())
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.CreateVpcEndpointRequest.ReadOnly =
    zio.aws.elasticsearch.model.CreateVpcEndpointRequest.wrap(buildAwsValue())
}
object CreateVpcEndpointRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.CreateVpcEndpointRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.CreateVpcEndpointRequest =
      zio.aws.elasticsearch.model.CreateVpcEndpointRequest(
        domainArn,
        vpcOptions.asEditable,
        clientToken.map(value => value)
      )
    def domainArn: DomainArn
    def vpcOptions: zio.aws.elasticsearch.model.VPCOptions.ReadOnly
    def clientToken: Optional[ClientToken]
    def getDomainArn: ZIO[Any, Nothing, DomainArn] = ZIO.succeed(domainArn)
    def getVpcOptions
        : ZIO[Any, Nothing, zio.aws.elasticsearch.model.VPCOptions.ReadOnly] =
      ZIO.succeed(vpcOptions)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.CreateVpcEndpointRequest
  ) extends zio.aws.elasticsearch.model.CreateVpcEndpointRequest.ReadOnly {
    override val domainArn: DomainArn =
      zio.aws.elasticsearch.model.primitives.DomainArn(impl.domainArn())
    override val vpcOptions: zio.aws.elasticsearch.model.VPCOptions.ReadOnly =
      zio.aws.elasticsearch.model.VPCOptions.wrap(impl.vpcOptions())
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.elasticsearch.model.primitives.ClientToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.CreateVpcEndpointRequest
  ): zio.aws.elasticsearch.model.CreateVpcEndpointRequest.ReadOnly =
    new Wrapper(impl)
}
