package zio.aws.elasticsearch.model
import scala.jdk.CollectionConverters._
sealed trait AutoTuneState {
  def unwrap: software.amazon.awssdk.services.elasticsearch.model.AutoTuneState
}
object AutoTuneState {
  def wrap(
      value: software.amazon.awssdk.services.elasticsearch.model.AutoTuneState
  ): zio.aws.elasticsearch.model.AutoTuneState = value match {
    case software.amazon.awssdk.services.elasticsearch.model.AutoTuneState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.elasticsearch.model.AutoTuneState.ENABLED =>
      val r = ENABLED
      r
    case software.amazon.awssdk.services.elasticsearch.model.AutoTuneState.DISABLED =>
      val r = DISABLED
      r
    case software.amazon.awssdk.services.elasticsearch.model.AutoTuneState.ENABLE_IN_PROGRESS =>
      val r = ENABLE_IN_PROGRESS
      r
    case software.amazon.awssdk.services.elasticsearch.model.AutoTuneState.DISABLE_IN_PROGRESS =>
      val r = DISABLE_IN_PROGRESS
      r
    case software.amazon.awssdk.services.elasticsearch.model.AutoTuneState.DISABLED_AND_ROLLBACK_SCHEDULED =>
      val r = DISABLED_AND_ROLLBACK_SCHEDULED
      r
    case software.amazon.awssdk.services.elasticsearch.model.AutoTuneState.DISABLED_AND_ROLLBACK_IN_PROGRESS =>
      val r = DISABLED_AND_ROLLBACK_IN_PROGRESS
      r
    case software.amazon.awssdk.services.elasticsearch.model.AutoTuneState.DISABLED_AND_ROLLBACK_COMPLETE =>
      val r = DISABLED_AND_ROLLBACK_COMPLETE
      r
    case software.amazon.awssdk.services.elasticsearch.model.AutoTuneState.DISABLED_AND_ROLLBACK_ERROR =>
      val r = DISABLED_AND_ROLLBACK_ERROR
      r
    case software.amazon.awssdk.services.elasticsearch.model.AutoTuneState.ERROR =>
      val r = ERROR
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.elasticsearch.model.AutoTuneState {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.AutoTuneState =
      software.amazon.awssdk.services.elasticsearch.model.AutoTuneState.UNKNOWN_TO_SDK_VERSION
  }
  case object ENABLED extends zio.aws.elasticsearch.model.AutoTuneState {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.AutoTuneState =
      software.amazon.awssdk.services.elasticsearch.model.AutoTuneState.ENABLED
  }
  case object DISABLED extends zio.aws.elasticsearch.model.AutoTuneState {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.AutoTuneState =
      software.amazon.awssdk.services.elasticsearch.model.AutoTuneState.DISABLED
  }
  case object ENABLE_IN_PROGRESS
      extends zio.aws.elasticsearch.model.AutoTuneState {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.AutoTuneState =
      software.amazon.awssdk.services.elasticsearch.model.AutoTuneState.ENABLE_IN_PROGRESS
  }
  case object DISABLE_IN_PROGRESS
      extends zio.aws.elasticsearch.model.AutoTuneState {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.AutoTuneState =
      software.amazon.awssdk.services.elasticsearch.model.AutoTuneState.DISABLE_IN_PROGRESS
  }
  case object DISABLED_AND_ROLLBACK_SCHEDULED
      extends zio.aws.elasticsearch.model.AutoTuneState {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.AutoTuneState =
      software.amazon.awssdk.services.elasticsearch.model.AutoTuneState.DISABLED_AND_ROLLBACK_SCHEDULED
  }
  case object DISABLED_AND_ROLLBACK_IN_PROGRESS
      extends zio.aws.elasticsearch.model.AutoTuneState {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.AutoTuneState =
      software.amazon.awssdk.services.elasticsearch.model.AutoTuneState.DISABLED_AND_ROLLBACK_IN_PROGRESS
  }
  case object DISABLED_AND_ROLLBACK_COMPLETE
      extends zio.aws.elasticsearch.model.AutoTuneState {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.AutoTuneState =
      software.amazon.awssdk.services.elasticsearch.model.AutoTuneState.DISABLED_AND_ROLLBACK_COMPLETE
  }
  case object DISABLED_AND_ROLLBACK_ERROR
      extends zio.aws.elasticsearch.model.AutoTuneState {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.AutoTuneState =
      software.amazon.awssdk.services.elasticsearch.model.AutoTuneState.DISABLED_AND_ROLLBACK_ERROR
  }
  case object ERROR extends zio.aws.elasticsearch.model.AutoTuneState {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.AutoTuneState =
      software.amazon.awssdk.services.elasticsearch.model.AutoTuneState.ERROR
  }
}
