package zio.aws.elasticsearch.model
import zio.aws.elasticsearch.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListVpcEndpointsRequest(
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.ListVpcEndpointsRequest = {
    import ListVpcEndpointsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.ListVpcEndpointsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.elasticsearch.model.ListVpcEndpointsRequest.ReadOnly =
    zio.aws.elasticsearch.model.ListVpcEndpointsRequest.wrap(buildAwsValue())
}
object ListVpcEndpointsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.ListVpcEndpointsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.ListVpcEndpointsRequest =
      zio.aws.elasticsearch.model
        .ListVpcEndpointsRequest(nextToken.map(value => value))
    def nextToken: Optional[NextToken]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.ListVpcEndpointsRequest
  ) extends zio.aws.elasticsearch.model.ListVpcEndpointsRequest.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.elasticsearch.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.ListVpcEndpointsRequest
  ): zio.aws.elasticsearch.model.ListVpcEndpointsRequest.ReadOnly = new Wrapper(
    impl
  )
}
