package zio.aws.elasticsearch.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.elasticsearch.model.primitives.{
  MaximumInstanceCount,
  MinimumInstanceCount
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class InstanceCountLimits(
    minimumInstanceCount: Optional[MinimumInstanceCount] = Optional.Absent,
    maximumInstanceCount: Optional[MaximumInstanceCount] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.InstanceCountLimits = {
    import InstanceCountLimits.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.InstanceCountLimits
      .builder()
      .optionallyWith(
        minimumInstanceCount.map(value =>
          MinimumInstanceCount.unwrap(value): Integer
        )
      )(_.minimumInstanceCount)
      .optionallyWith(
        maximumInstanceCount.map(value =>
          MaximumInstanceCount.unwrap(value): Integer
        )
      )(_.maximumInstanceCount)
      .build()
  }
  def asReadOnly: zio.aws.elasticsearch.model.InstanceCountLimits.ReadOnly =
    zio.aws.elasticsearch.model.InstanceCountLimits.wrap(buildAwsValue())
}
object InstanceCountLimits {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.InstanceCountLimits
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.InstanceCountLimits =
      zio.aws.elasticsearch.model.InstanceCountLimits(
        minimumInstanceCount.map(value => value),
        maximumInstanceCount.map(value => value)
      )
    def minimumInstanceCount: Optional[MinimumInstanceCount]
    def maximumInstanceCount: Optional[MaximumInstanceCount]
    def getMinimumInstanceCount: ZIO[Any, AwsError, MinimumInstanceCount] =
      AwsError.unwrapOptionField("minimumInstanceCount", minimumInstanceCount)
    def getMaximumInstanceCount: ZIO[Any, AwsError, MaximumInstanceCount] =
      AwsError.unwrapOptionField("maximumInstanceCount", maximumInstanceCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.InstanceCountLimits
  ) extends zio.aws.elasticsearch.model.InstanceCountLimits.ReadOnly {
    override val minimumInstanceCount: Optional[MinimumInstanceCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.minimumInstanceCount())
        .map(value =>
          zio.aws.elasticsearch.model.primitives.MinimumInstanceCount(value)
        )
    override val maximumInstanceCount: Optional[MaximumInstanceCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maximumInstanceCount())
        .map(value =>
          zio.aws.elasticsearch.model.primitives.MaximumInstanceCount(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.InstanceCountLimits
  ): zio.aws.elasticsearch.model.InstanceCountLimits.ReadOnly = new Wrapper(
    impl
  )
}
