package zio.aws.elasticsearch.model
import zio.aws.elasticsearch.model.primitives.{Message, GUID}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ChangeProgressDetails(
    changeId: Optional[GUID] = Optional.Absent,
    message: Optional[Message] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.ChangeProgressDetails = {
    import ChangeProgressDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.ChangeProgressDetails
      .builder()
      .optionallyWith(
        changeId.map(value => GUID.unwrap(value): java.lang.String)
      )(_.changeId)
      .optionallyWith(
        message.map(value => Message.unwrap(value): java.lang.String)
      )(_.message)
      .build()
  }
  def asReadOnly: zio.aws.elasticsearch.model.ChangeProgressDetails.ReadOnly =
    zio.aws.elasticsearch.model.ChangeProgressDetails.wrap(buildAwsValue())
}
object ChangeProgressDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.ChangeProgressDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.ChangeProgressDetails =
      zio.aws.elasticsearch.model.ChangeProgressDetails(
        changeId.map(value => value),
        message.map(value => value)
      )
    def changeId: Optional[GUID]
    def message: Optional[Message]
    def getChangeId: ZIO[Any, AwsError, GUID] =
      AwsError.unwrapOptionField("changeId", changeId)
    def getMessage: ZIO[Any, AwsError, Message] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.ChangeProgressDetails
  ) extends zio.aws.elasticsearch.model.ChangeProgressDetails.ReadOnly {
    override val changeId: Optional[GUID] = zio.aws.core.internal
      .optionalFromNullable(impl.changeId())
      .map(value => zio.aws.elasticsearch.model.primitives.GUID(value))
    override val message: Optional[Message] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => zio.aws.elasticsearch.model.primitives.Message(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.ChangeProgressDetails
  ): zio.aws.elasticsearch.model.ChangeProgressDetails.ReadOnly = new Wrapper(
    impl
  )
}
