package zio.aws.elasticsearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AutoTuneOptionsStatus(
    options: Optional[zio.aws.elasticsearch.model.AutoTuneOptions] =
      Optional.Absent,
    status: Optional[zio.aws.elasticsearch.model.AutoTuneStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.AutoTuneOptionsStatus = {
    import AutoTuneOptionsStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.AutoTuneOptionsStatus
      .builder()
      .optionallyWith(options.map(value => value.buildAwsValue()))(_.options)
      .optionallyWith(status.map(value => value.buildAwsValue()))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.elasticsearch.model.AutoTuneOptionsStatus.ReadOnly =
    zio.aws.elasticsearch.model.AutoTuneOptionsStatus.wrap(buildAwsValue())
}
object AutoTuneOptionsStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.AutoTuneOptionsStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.AutoTuneOptionsStatus =
      zio.aws.elasticsearch.model.AutoTuneOptionsStatus(
        options.map(value => value.asEditable),
        status.map(value => value.asEditable)
      )
    def options: Optional[zio.aws.elasticsearch.model.AutoTuneOptions.ReadOnly]
    def status: Optional[zio.aws.elasticsearch.model.AutoTuneStatus.ReadOnly]
    def getOptions: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.AutoTuneOptions.ReadOnly
    ] = AwsError.unwrapOptionField("options", options)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.AutoTuneStatus.ReadOnly
    ] = AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.AutoTuneOptionsStatus
  ) extends zio.aws.elasticsearch.model.AutoTuneOptionsStatus.ReadOnly {
    override val options
        : Optional[zio.aws.elasticsearch.model.AutoTuneOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.options())
        .map(value => zio.aws.elasticsearch.model.AutoTuneOptions.wrap(value))
    override val status
        : Optional[zio.aws.elasticsearch.model.AutoTuneStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.elasticsearch.model.AutoTuneStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.AutoTuneOptionsStatus
  ): zio.aws.elasticsearch.model.AutoTuneOptionsStatus.ReadOnly = new Wrapper(
    impl
  )
}
