package zio.aws.elasticsearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AutoTuneOptionsOutput(
    state: Optional[zio.aws.elasticsearch.model.AutoTuneState] =
      Optional.Absent,
    errorMessage: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.AutoTuneOptionsOutput = {
    import AutoTuneOptionsOutput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.AutoTuneOptionsOutput
      .builder()
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(errorMessage.map(value => value: java.lang.String))(
        _.errorMessage
      )
      .build()
  }
  def asReadOnly: zio.aws.elasticsearch.model.AutoTuneOptionsOutput.ReadOnly =
    zio.aws.elasticsearch.model.AutoTuneOptionsOutput.wrap(buildAwsValue())
}
object AutoTuneOptionsOutput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.AutoTuneOptionsOutput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.AutoTuneOptionsOutput =
      zio.aws.elasticsearch.model.AutoTuneOptionsOutput(
        state.map(value => value),
        errorMessage.map(value => value)
      )
    def state: Optional[zio.aws.elasticsearch.model.AutoTuneState]
    def errorMessage: Optional[String]
    def getState
        : ZIO[Any, AwsError, zio.aws.elasticsearch.model.AutoTuneState] =
      AwsError.unwrapOptionField("state", state)
    def getErrorMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.AutoTuneOptionsOutput
  ) extends zio.aws.elasticsearch.model.AutoTuneOptionsOutput.ReadOnly {
    override val state: Optional[zio.aws.elasticsearch.model.AutoTuneState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.elasticsearch.model.AutoTuneState.wrap(value))
    override val errorMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.errorMessage())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.AutoTuneOptionsOutput
  ): zio.aws.elasticsearch.model.AutoTuneOptionsOutput.ReadOnly = new Wrapper(
    impl
  )
}
