package zio.aws.elasticsearch.model
import zio.aws.elasticsearch.model.primitives.VpcEndpointId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeVpcEndpointsRequest(
    vpcEndpointIds: Iterable[VpcEndpointId]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.DescribeVpcEndpointsRequest = {
    import DescribeVpcEndpointsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.DescribeVpcEndpointsRequest
      .builder()
      .vpcEndpointIds(vpcEndpointIds.map { item =>
        VpcEndpointId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.DescribeVpcEndpointsRequest.ReadOnly =
    zio.aws.elasticsearch.model.DescribeVpcEndpointsRequest
      .wrap(buildAwsValue())
}
object DescribeVpcEndpointsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.DescribeVpcEndpointsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.DescribeVpcEndpointsRequest =
      zio.aws.elasticsearch.model.DescribeVpcEndpointsRequest(vpcEndpointIds)
    def vpcEndpointIds: List[VpcEndpointId]
    def getVpcEndpointIds: ZIO[Any, Nothing, List[VpcEndpointId]] =
      ZIO.succeed(vpcEndpointIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.DescribeVpcEndpointsRequest
  ) extends zio.aws.elasticsearch.model.DescribeVpcEndpointsRequest.ReadOnly {
    override val vpcEndpointIds: List[VpcEndpointId] = impl
      .vpcEndpointIds()
      .asScala
      .map { item =>
        zio.aws.elasticsearch.model.primitives.VpcEndpointId(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.DescribeVpcEndpointsRequest
  ): zio.aws.elasticsearch.model.DescribeVpcEndpointsRequest.ReadOnly =
    new Wrapper(impl)
}
