package zio.aws.elasticsearch.model
import zio.aws.elasticsearch.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeInboundCrossClusterSearchConnectionsResponse(
    crossClusterSearchConnections: Optional[
      Iterable[zio.aws.elasticsearch.model.InboundCrossClusterSearchConnection]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.DescribeInboundCrossClusterSearchConnectionsResponse = {
    import DescribeInboundCrossClusterSearchConnectionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.DescribeInboundCrossClusterSearchConnectionsResponse
      .builder()
      .optionallyWith(
        crossClusterSearchConnections.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.crossClusterSearchConnections)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.DescribeInboundCrossClusterSearchConnectionsResponse.ReadOnly =
    zio.aws.elasticsearch.model.DescribeInboundCrossClusterSearchConnectionsResponse
      .wrap(buildAwsValue())
}
object DescribeInboundCrossClusterSearchConnectionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.DescribeInboundCrossClusterSearchConnectionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticsearch.model.DescribeInboundCrossClusterSearchConnectionsResponse =
      zio.aws.elasticsearch.model
        .DescribeInboundCrossClusterSearchConnectionsResponse(
          crossClusterSearchConnections.map(value =>
            value.map { item =>
              item.asEditable
            }
          ),
          nextToken.map(value => value)
        )
    def crossClusterSearchConnections: Optional[List[
      zio.aws.elasticsearch.model.InboundCrossClusterSearchConnection.ReadOnly
    ]]
    def nextToken: Optional[NextToken]
    def getCrossClusterSearchConnections: ZIO[Any, AwsError, List[
      zio.aws.elasticsearch.model.InboundCrossClusterSearchConnection.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "crossClusterSearchConnections",
      crossClusterSearchConnections
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.DescribeInboundCrossClusterSearchConnectionsResponse
  ) extends zio.aws.elasticsearch.model.DescribeInboundCrossClusterSearchConnectionsResponse.ReadOnly {
    override val crossClusterSearchConnections: Optional[List[
      zio.aws.elasticsearch.model.InboundCrossClusterSearchConnection.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.crossClusterSearchConnections())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticsearch.model.InboundCrossClusterSearchConnection
            .wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.elasticsearch.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.DescribeInboundCrossClusterSearchConnectionsResponse
  ): zio.aws.elasticsearch.model.DescribeInboundCrossClusterSearchConnectionsResponse.ReadOnly =
    new Wrapper(impl)
}
